/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.search.v2;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.BooleanQueryBuilder;
import com.atlassian.confluence.search.v2.SearchFieldMappings;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@Internal
public class CustomContentTypeQueryFactory<T> {
    private final Set<String> pluginKeys;
    private final Supplier<BooleanQueryBuilder<T>> boolBuilderSupplier;
    private final Supplier<BiFunction<String, String, T>> termBuilderSupplier;

    public CustomContentTypeQueryFactory(Set<String> pluginKeys, Supplier<BooleanQueryBuilder<T>> boolBuilderSupplier, Supplier<BiFunction<String, String, T>> termBuilderSupplier) {
        this.pluginKeys = pluginKeys;
        this.boolBuilderSupplier = boolBuilderSupplier;
        this.termBuilderSupplier = termBuilderSupplier;
    }

    public T create() {
        Collection pluginKeyQueries = this.pluginKeys.stream().map(x -> this.termBuilderSupplier.get().apply(SearchFieldMappings.CONTENT_PLUGIN_KEY.getName(), (String)x)).collect(Collectors.toList());
        return this.boolBuilderSupplier.get().addMust(this.termBuilderSupplier.get().apply(SearchFieldMappings.TYPE.getName(), ContentTypeEnum.CUSTOM.getRepresentation())).addMust(this.boolBuilderSupplier.get().addShould(pluginKeyQueries).build()).build();
    }
}

