/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.search.v2;

import com.atlassian.confluence.internal.search.v2.LuceneAutoCorrectRawQueryParser;
import com.atlassian.confluence.internal.search.v2.lucene.LuceneQueryParserFactory;
import com.atlassian.confluence.plugins.index.api.AnalyzerDescriptorProvider;
import com.atlassian.confluence.search.v2.BooleanOperator;
import com.atlassian.confluence.search.v2.query.QueryStringQuery;
import com.atlassian.confluence.search.v2.query.TextFieldQuery;
import io.atlassian.fugue.Either;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAutoCorrectRawQueryTransformer
implements LuceneAutoCorrectRawQueryParser {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAutoCorrectRawQueryTransformer.class);
    private final LuceneQueryParserFactory luceneQueryParserFactory;

    public DefaultAutoCorrectRawQueryTransformer(LuceneQueryParserFactory luceneQueryParserFactory) {
        this.luceneQueryParserFactory = luceneQueryParserFactory;
    }

    @Override
    public QueryStringQuery transform(QueryStringQuery query, Function<String, String> transformer) {
        return (QueryStringQuery)this.tryParse(query, transformer).map(x -> query).valueOr(transformed -> new QueryStringQuery(query.getFieldNames(), query.getAnalyzerProviders(), query.getOperator(), transformed.getQuery(), query.getFieldsBoost()));
    }

    @Override
    public Query parse(QueryStringQuery query, Function<String, String> transformer) {
        return (Query)this.tryParse(query, transformer).valueOr(TransformedQuery::parseQuery);
    }

    private Either<TransformedQuery, Query> tryParse(QueryStringQuery query, Function<String, String> transformer) {
        CharSequence[] charSequenceArray;
        StandardQueryParser queryParser = this.luceneQueryParserFactory.createQueryParser(query.getAnalyzerProviders());
        if (query.getFieldNames().isEmpty()) {
            String[] stringArray = new String[1];
            charSequenceArray = stringArray;
            stringArray[0] = "";
        } else {
            charSequenceArray = query.getFieldNames().toArray(new String[0]);
        }
        queryParser.setMultiFields(charSequenceArray);
        queryParser.setFieldsBoost(query.getFieldsBoost());
        queryParser.setDefaultOperator(this.getOperator(query.getOperator()));
        return this.tryParse(queryParser, query.getQuery(), null, transformer);
    }

    @Override
    public TextFieldQuery transform(TextFieldQuery query, Function<String, String> transformer) {
        return (TextFieldQuery)this.tryParse(query, transformer).map(x -> query).valueOr(transformed -> new TextFieldQuery(query.getFieldName(), query.getAnalyzerDescriptorProvider(), query.getOperator(), transformed.getQuery()));
    }

    @Override
    public Query parse(TextFieldQuery query, Function<String, String> transformer) {
        return (Query)this.tryParse(query, transformer).valueOr(TransformedQuery::parseQuery);
    }

    private Either<TransformedQuery, Query> tryParse(TextFieldQuery query, Function<String, String> transformer) {
        Map<String, AnalyzerDescriptorProvider> fieldAnalyzers = Collections.singletonMap(query.getFieldName(), query::getAnalyzer);
        StandardQueryParser queryParser = this.luceneQueryParserFactory.createQueryParser(fieldAnalyzers);
        queryParser.setDefaultOperator(this.getOperator(query.getOperator()));
        return this.tryParse(queryParser, query.getUnescapedQuery(), query.getFieldName(), transformer);
    }

    private Either<TransformedQuery, Query> tryParse(StandardQueryParser queryParser, String query, String defaultField, Function<String, String> transformer) {
        try {
            return Either.right((Object)queryParser.parse(query, defaultField));
        }
        catch (QueryNodeException e) {
            logger.debug("Could not parse query string", (Throwable)e);
            String transformedQuery = transformer.apply(query);
            return Either.left((Object)new TransformedQuery(queryParser, transformedQuery, defaultField));
        }
    }

    private StandardQueryConfigHandler.Operator getOperator(BooleanOperator operator) {
        return BooleanOperator.AND == operator ? StandardQueryConfigHandler.Operator.AND : StandardQueryConfigHandler.Operator.OR;
    }

    private static class TransformedQuery {
        private final String transformedQuery;
        private final String defaultField;
        private final StandardQueryParser queryParser;

        TransformedQuery(StandardQueryParser queryParser, String transformedQuery, String defaultField) {
            this.transformedQuery = transformedQuery;
            this.queryParser = queryParser;
            this.defaultField = defaultField;
        }

        String getQuery() {
            return this.transformedQuery;
        }

        Query parseQuery() {
            try {
                return this.queryParser.parse(this.transformedQuery, this.defaultField);
            }
            catch (QueryNodeException e2) {
                throw new IllegalArgumentException(e2);
            }
        }
    }
}

