/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.search.v2;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.internal.ApplicationConfig;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.admin.GlobalSettingsChangedEvent;
import com.atlassian.confluence.event.events.admin.ReindexFinishedEvent;
import com.atlassian.confluence.event.events.admin.SiteDarkFeatureDisabledEvent;
import com.atlassian.confluence.event.events.admin.SiteDarkFeatureEnabledEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.confluence.event.events.lifecycle.ApplicationStartedEvent;
import com.atlassian.confluence.search.ReIndexOption;
import com.atlassian.confluence.search.SearchLanguage;
import com.atlassian.confluence.search.SearchPlatform;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExactSearchController
implements Supplier<Boolean> {
    private static final Logger logger = LoggerFactory.getLogger(ExactSearchController.class);
    public static final String SEARCH_IMPROVEMENTS_EXACT_DARK_FEATURE_DISABLE_KEY = "confluence.open.search.improvements.exact.disable";
    public static final String SEARCH_IMPROVEMENTS_EXACT_DARK_FEATURE_PROPERTY_KEY = "atlassian.darkfeature.confluence.search.improvements.exact";
    public static final String SEARCH_IMPROVEMENTS_EXACT_DARK_FEATURE_OVERRIDE_ENABLE_KEY = "confluence.open.search.improvements.exact.scriptio.continua.enable";
    static final String EXACT_SEARCH_PROPERTY_KEY = "exact.search";
    private final EventListenerRegistrar eventListenerRegistrar;
    private final DarkFeatureManager darkFeatureManager;
    private final ApplicationConfig applicationConfig;
    private final PluginSettings globalPluginSettings;
    private final GlobalSettingsManager globalSettingsManager;

    public ExactSearchController(EventListenerRegistrar eventListenerRegistrar, DarkFeatureManager darkFeatureManager, ApplicationConfig applicationConfig, PluginSettingsFactory pluginSettingsFactory, GlobalSettingsManager globalSettingsManager) {
        this.eventListenerRegistrar = Objects.requireNonNull(eventListenerRegistrar);
        this.darkFeatureManager = Objects.requireNonNull(darkFeatureManager);
        this.applicationConfig = Objects.requireNonNull(applicationConfig);
        this.globalPluginSettings = Objects.requireNonNull(pluginSettingsFactory).createGlobalSettings();
        this.globalSettingsManager = Objects.requireNonNull(globalSettingsManager);
    }

    @PostConstruct
    public void registerEventListener() {
        this.eventListenerRegistrar.register((Object)this);
    }

    @PreDestroy
    public void unregisterEventListener() {
        this.eventListenerRegistrar.unregister((Object)this);
    }

    @EventListener
    public void onReindexingFinish(ReindexFinishedEvent event) {
        logger.debug("Handle ReindexFinishedEvent in ExactSearchController");
        if (!SearchPlatform.OPENSEARCH.equals((Object)SearchPlatform.getSearchPlatform((ApplicationConfiguration)this.applicationConfig))) {
            logger.debug("Not enabling Exact Search by default because search platform is not OpenSearch");
            return;
        }
        if (!this.isExactSearchIndexingEnabled()) {
            logger.debug("Not enabling Exact Search query because Exact Search indexing is not enabled");
            return;
        }
        if (!(event.getOptions().contains(ReIndexOption.CONTENT_ONLY) && event.getOptions().contains(ReIndexOption.ATTACHMENT_ONLY) && event.getSpaceKeys().equals(Collections.emptyList()))) {
            logger.debug("Not enabling Exact Search query because reindex is not full reindex");
            return;
        }
        this.setExactSearchQueryFlag(true);
    }

    @EventListener
    public void onApplicationStartedEvent(ApplicationStartedEvent event) {
        logger.debug("Handle ApplicationStartedEvent in ExactSearchController");
        boolean shouldTurnOnExactSearch = this.shouldEnableExactSearchSysProp();
        this.setDarkFeaturePropertyOnStartUp("confluence.search.improvements.exact", Optional.of(shouldTurnOnExactSearch));
        if (shouldTurnOnExactSearch) {
            logger.info("Exact search enabled for indexing");
        }
    }

    @EventListener
    public void handleClusterEvent(ClusterEventWrapper event) {
        ConfluenceEvent originalEvent;
        ClusterEvent wrapped = event.getEvent();
        if (wrapped instanceof SiteDarkFeatureEnabledEvent) {
            originalEvent = (SiteDarkFeatureEnabledEvent)wrapped;
            logger.debug("Handle SiteDarkFeatureEnabledEvent remotely");
            this.setDarkFeatureProperty(((SiteDarkFeatureEnabledEvent)originalEvent).getFeatureKey(), Optional.of(true));
        }
        if (wrapped instanceof SiteDarkFeatureDisabledEvent) {
            originalEvent = (SiteDarkFeatureDisabledEvent)wrapped;
            logger.debug("Handle SiteDarkFeatureDisabledEvent remotely");
            this.setDarkFeatureProperty(((SiteDarkFeatureDisabledEvent)originalEvent).getFeatureKey(), Optional.empty());
        }
        if (wrapped instanceof GlobalSettingsChangedEvent) {
            originalEvent = (GlobalSettingsChangedEvent)wrapped;
            this.onGlobalSettingsChangedEvent((GlobalSettingsChangedEvent)originalEvent);
        }
    }

    @EventListener
    public void onSiteDarkFeatureEnabled(SiteDarkFeatureEnabledEvent event) {
        logger.debug("Handle SiteDarkFeatureEnabledEvent locally");
        this.setDarkFeatureProperty(event.getFeatureKey(), Optional.of(true));
    }

    @EventListener
    public void onSiteDarkFeatureDisabledEvent(SiteDarkFeatureDisabledEvent event) {
        logger.debug("Handle SiteDarkFeatureDisabledEvent locally");
        this.setDarkFeatureProperty(event.getFeatureKey(), Optional.empty());
    }

    @EventListener
    public void onGlobalSettingsChangedEvent(GlobalSettingsChangedEvent event) {
        logger.debug("Handle GlobalSettingsChangedEvent in ExactSearchController");
        String oldLanguage = event.getOldSettings().getIndexingLanguage();
        String newLanguage = event.getNewSettings().getIndexingLanguage();
        if (!Objects.equals(oldLanguage, newLanguage)) {
            ExactSearchController.setExactSearchSystemPropertyValue(this.shouldEnableExactSearchSysProp());
        }
    }

    private boolean shouldEnableExactSearchSysProp() {
        Settings settings = this.globalSettingsManager.getGlobalSettings();
        if (settings == null) {
            logger.error("Not enabling Exact Search by default because global settings is null");
            return false;
        }
        if (SearchPlatform.OPENSEARCH.equals((Object)SearchPlatform.getSearchPlatform((ApplicationConfiguration)this.applicationConfig))) {
            logger.debug("Handle for OpenSearch search");
            if (this.darkFeatureManager.isEnabledForAllUsers(SEARCH_IMPROVEMENTS_EXACT_DARK_FEATURE_DISABLE_KEY).orElse(false).booleanValue()) {
                logger.debug("Exact Search is not enabled for indexing, as the 'disable' dark feature is enabled");
                return false;
            }
            if ((Objects.equals(settings.getIndexingLanguage(), SearchLanguage.CHINESE.value) || Objects.equals(settings.getIndexingLanguage(), SearchLanguage.CUSTOM_JAPANESE.value) || Objects.equals(settings.getIndexingLanguage(), SearchLanguage.CJK.value)) && !this.darkFeatureManager.isEnabledForAllUsers(SEARCH_IMPROVEMENTS_EXACT_DARK_FEATURE_OVERRIDE_ENABLE_KEY).orElse(false).booleanValue()) {
                logger.debug("Not enabling Exact Search by default because indexing language is not yet supported properly for exact search");
                logger.debug("To override this, please set the dark feature '{}' to true", (Object)SEARCH_IMPROVEMENTS_EXACT_DARK_FEATURE_OVERRIDE_ENABLE_KEY);
                return false;
            }
            logger.debug("Exact Search is enabled for indexing, as the override dark feature is enabled");
            return true;
        }
        if (SearchPlatform.LUCENE.equals((Object)SearchPlatform.getSearchPlatform((ApplicationConfiguration)this.applicationConfig))) {
            logger.debug("Handle for Lucene search");
            if (!this.darkFeatureManager.isEnabledForAllUsers("confluence.search.improvements.exact").orElse(false).booleanValue()) {
                logger.debug("Exact Search is not enabled for indexing, as the dark feature is not enabled");
                return false;
            }
            logger.debug("Exact Search is enabled for indexing, as the dark feature is enabled");
            return true;
        }
        return false;
    }

    private void setDarkFeaturePropertyOnStartUp(String darkFeatureKey, Optional<Boolean> value) {
        this.setDarkFeatureProperty(darkFeatureKey, value);
        if (SearchPlatform.OPENSEARCH.equals((Object)SearchPlatform.getSearchPlatform((ApplicationConfiguration)this.applicationConfig)) && "confluence.search.improvements.exact".equals(darkFeatureKey)) {
            ExactSearchController.setExactSearchSystemPropertyValue(value.orElse(false));
        }
    }

    private void setDarkFeatureProperty(String darkFeatureKey, Optional<Boolean> value) {
        if (SearchPlatform.LUCENE.equals((Object)SearchPlatform.getSearchPlatform((ApplicationConfiguration)this.applicationConfig)) && "confluence.search.improvements.exact".equals(darkFeatureKey)) {
            logger.debug("Handling Dark Feature for exact search on Lucene search");
            if (value.isEmpty()) {
                logger.debug("Clear {} property", (Object)"confluence.search.improvements.exact");
                System.clearProperty(SEARCH_IMPROVEMENTS_EXACT_DARK_FEATURE_PROPERTY_KEY);
                return;
            }
            boolean propertyValue = value.orElse(false);
            ExactSearchController.setExactSearchSystemPropertyValue(propertyValue);
        }
        if (SearchPlatform.OPENSEARCH.equals((Object)SearchPlatform.getSearchPlatform((ApplicationConfiguration)this.applicationConfig)) && SEARCH_IMPROVEMENTS_EXACT_DARK_FEATURE_DISABLE_KEY.equals(darkFeatureKey)) {
            logger.debug("Handling Dark Feature for exact search on OpenSearch search");
            boolean shouldDisableExactSearch = value.orElse(false);
            logger.debug("Clean Exact Search query flag");
            this.setExactSearchQueryFlag(false);
            boolean propertyValue = !shouldDisableExactSearch;
            ExactSearchController.setExactSearchSystemPropertyValue(propertyValue);
        }
    }

    private void setExactSearchQueryFlag(boolean value) {
        try {
            logger.info("Setting exact search query flag to {}", (Object)value);
            this.globalPluginSettings.put(EXACT_SEARCH_PROPERTY_KEY, (Object)value);
        }
        catch (Exception e) {
            logger.error("Error setting exact search properties after indexing finished. Exact Search is not enabled until next reindex, ensure the exact search disable flag is not set.  ", (Throwable)e);
        }
    }

    private static void setExactSearchSystemPropertyValue(boolean propertyValue) {
        logger.debug("Set {} property with value {}", (Object)SEARCH_IMPROVEMENTS_EXACT_DARK_FEATURE_PROPERTY_KEY, (Object)propertyValue);
        if (propertyValue) {
            System.setProperty(SEARCH_IMPROVEMENTS_EXACT_DARK_FEATURE_PROPERTY_KEY, String.valueOf(propertyValue));
        } else {
            System.clearProperty(SEARCH_IMPROVEMENTS_EXACT_DARK_FEATURE_PROPERTY_KEY);
        }
    }

    public boolean isExactSearchQueryEnabled() {
        if (SearchPlatform.LUCENE.equals((Object)SearchPlatform.getSearchPlatform((ApplicationConfiguration)this.applicationConfig))) {
            boolean shouldEnable = this.darkFeatureManager.isEnabledForAllUsers("confluence.search.improvements.exact").orElse(false);
            logger.debug("Check if exact search query flag is enabled for Lucene search is: {}", (Object)shouldEnable);
            return shouldEnable;
        }
        if (SearchPlatform.OPENSEARCH.equals((Object)SearchPlatform.getSearchPlatform((ApplicationConfiguration)this.applicationConfig)) && this.isExactSearchIndexingEnabled()) {
            boolean shouldEnable = this.isConfluenceIndexed();
            logger.debug("Check if Exact Search query flag is enabled for Open search is: {}", (Object)shouldEnable);
            return shouldEnable;
        }
        return false;
    }

    public boolean isExactSearchIndexingEnabled() {
        return Boolean.getBoolean(SEARCH_IMPROVEMENTS_EXACT_DARK_FEATURE_PROPERTY_KEY);
    }

    private boolean isConfluenceIndexed() {
        return Boolean.TRUE.equals(this.globalPluginSettings.get(EXACT_SEARCH_PROPERTY_KEY));
    }

    @Override
    public Boolean get() {
        return this.isExactSearchQueryEnabled();
    }
}

