/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.search.v2;

import com.atlassian.confluence.plugin.descriptor.AbstractFieldMappingsProviderModuleDescriptor;
import com.atlassian.confluence.plugins.index.api.mapping.FieldMapping;
import com.atlassian.confluence.plugins.index.api.mapping.FieldMappingsProvider;
import com.atlassian.confluence.search.v2.CustomSearchIndexRegistry;
import com.atlassian.confluence.search.v2.FieldMappings;
import com.atlassian.confluence.search.v2.Index;
import com.atlassian.confluence.search.v2.SearchIndexAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import java.util.Collection;
import java.util.Map;

public class FieldMappingsProviderModuleRegistrar {
    private final Map<Index, SearchIndexAccessor> systemIndexAccessors;
    private final CustomSearchIndexRegistry customSearchIndexRegistry;

    public FieldMappingsProviderModuleRegistrar(SearchIndexAccessor contentSearchIndexAccessor, SearchIndexAccessor changeSearchIndexAccessor, CustomSearchIndexRegistry customSearchIndexRegistry, PluginEventManager pluginEventManager) {
        this.systemIndexAccessors = Map.of(Index.CONTENT, contentSearchIndexAccessor, Index.CHANGE, changeSearchIndexAccessor);
        this.customSearchIndexRegistry = customSearchIndexRegistry;
        pluginEventManager.register((Object)this);
    }

    @PluginEventListener
    public void pluginModuleEnabled(PluginModuleEnabledEvent event) {
        if (event.getModule() instanceof AbstractFieldMappingsProviderModuleDescriptor) {
            AbstractFieldMappingsProviderModuleDescriptor descriptor = (AbstractFieldMappingsProviderModuleDescriptor)event.getModule();
            this.register(descriptor);
        }
    }

    private void register(AbstractFieldMappingsProviderModuleDescriptor<? extends FieldMappingsProvider> descriptor) {
        Collection<FieldMapping> fieldMappings = ((FieldMappingsProvider)descriptor.getModule()).getFieldMappings();
        for (Index index : descriptor.getIndices()) {
            SearchIndexAccessor accessor = this.getIndexAccessor(index);
            FieldMappings fieldMappings1 = accessor.getFieldMappings();
            for (FieldMapping fieldMapping : fieldMappings) {
                fieldMappings1.addMapping(fieldMapping);
            }
        }
    }

    private SearchIndexAccessor getIndexAccessor(Index index) {
        if (index.getType() == Index.Type.SYSTEM) {
            SearchIndexAccessor accessor = this.systemIndexAccessors.get(index);
            if (accessor == null) {
                throw new IllegalArgumentException("Invalid system index " + String.valueOf(index));
            }
            return accessor;
        }
        return this.customSearchIndexRegistry.get(index.getName());
    }
}

