/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.search.v2.lucene;

import com.atlassian.confluence.internal.search.v2.lucene.LuceneSearchResult;
import com.atlassian.confluence.search.summary.HitHighlighter;
import com.atlassian.confluence.search.v2.ProjectedSearchResult;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.user.ConfluenceUser;
import com.google.common.base.Function;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneSearchResultFactory {
    private static final Logger logger = LoggerFactory.getLogger(LuceneSearchResultFactory.class);
    private final com.atlassian.confluence.impl.search.v2.UserLookupHelper userLookupHelper = new com.atlassian.confluence.impl.search.v2.UserLookupHelper();
    private final Set<String> requestedFields;
    private final boolean shouldLogExplain;

    public LuceneSearchResultFactory() {
        this(Collections.emptySet());
    }

    public LuceneSearchResultFactory(Set<String> requestedFields) {
        this.requestedFields = requestedFields != null ? requestedFields : Collections.emptySet();
        this.shouldLogExplain = Boolean.getBoolean("confluence.lucene.query.explain");
    }

    SearchResult createSearchResult(ScoreDoc hit, IndexSearcher searcher) throws IOException {
        Document doc;
        if (!this.hasRequestedFields()) {
            doc = searcher.doc(hit.doc);
        } else {
            DocumentStoredFieldVisitor selector = new DocumentStoredFieldVisitor(this.requestedFields);
            searcher.doc(hit.doc, (StoredFieldVisitor)selector);
            doc = selector.getDocument();
        }
        return this.createSearchResult(doc, Optional.empty());
    }

    SearchResult createSearchResult(Document document, Optional<HitHighlighter> maybeHighlighter) {
        return this.createSearchResult(document, maybeHighlighter, Optional.empty());
    }

    public SearchResult createSearchResult(Document document, Optional<HitHighlighter> maybeHighlighter, Optional<String> maybeExplanation) {
        LuceneSearchResult result = new LuceneSearchResult(document, maybeHighlighter, maybeExplanation, (java.util.function.Function<String, ConfluenceUser>)((Object)this.userLookupHelper));
        if (this.shouldLogExplain) {
            logger.debug("Search result explanation: {}", (Object)result.getExplain().orElse("no explanation"));
        }
        if (!this.hasRequestedFields()) {
            return result;
        }
        return new ProjectedSearchResult(result, this.requestedFields);
    }

    private boolean hasRequestedFields() {
        return !this.requestedFields.isEmpty();
    }

    @Deprecated
    public static class UserLookupHelper
    implements Function<String, ConfluenceUser> {
        private final Function<String, ConfluenceUser> delegate = new com.atlassian.confluence.impl.search.v2.UserLookupHelper();

        public ConfluenceUser apply(String input) {
            return (ConfluenceUser)this.delegate.apply((Object)input);
        }
    }
}

