/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.security;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.util.profiling.Timers;
import java.text.MessageFormat;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;

public class DebuggingString {
    static final DebuggingString EMPTY_DEBUG_STR = new DebuggingString("()");
    public final String value;

    private DebuggingString(String value) {
        this.value = value;
    }

    public static DebuggingString of(String value) {
        return new DebuggingString(value);
    }

    public String toString() {
        return this.value;
    }

    public static DebuggingString getPermissionCheckAsString(Logger log, String permissionType, @Nullable Space space, @Nullable ConfluenceUser remoteUser) {
        if (!Timers.getConfiguration().isEnabled() && !log.isDebugEnabled()) {
            return EMPTY_DEBUG_STR;
        }
        String permissionCheckDescription = MessageFormat.format("({0}, {1}, {2})", permissionType, remoteUser != null ? remoteUser.getName() : "anonymous", space != null ? space.getKey() : "global");
        return DebuggingString.of(permissionCheckDescription);
    }
}

