/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.security;

import com.atlassian.confluence.internal.security.SpacePermissionContext;
import com.atlassian.confluence.internal.security.SpacePermissionManagerInternal;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.Group;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.transaction.annotation.Transactional;

public class DelegatingSpacePermissionManager
implements SpacePermissionManagerInternal {
    private final SpacePermissionManagerInternal delegate;

    public DelegatingSpacePermissionManager(SpacePermissionManagerInternal delegate) {
        this.delegate = delegate;
    }

    @Override
    public void removeAllPermissions(Space space, SpacePermissionContext context) {
        this.delegate.removeAllPermissions(space, context);
    }

    @Override
    public void removePermission(SpacePermission permission, SpacePermissionContext context) {
        this.delegate.removePermission(permission, context);
    }

    @Override
    public void removePermissions(Collection<SpacePermission> permissionsToRemove, SpacePermissionContext context) {
        this.delegate.removePermissions(permissionsToRemove, context);
    }

    @Override
    public void removeAllUserPermissions(ConfluenceUser user, SpacePermissionContext context) {
        this.delegate.removeAllUserPermissions(user, context);
    }

    @Override
    public void removeGlobalPermissionForUser(ConfluenceUser user, String permissionType, SpacePermissionContext context) {
        this.delegate.removeGlobalPermissionForUser(user, permissionType, context);
    }

    @Override
    public void removeAllPermissionsForGroup(String group, SpacePermissionContext context) {
        this.delegate.removeAllPermissionsForGroup(group, context);
    }

    @Override
    @Deprecated
    public void removeAllPermissions(Space space) {
        this.delegate.removeAllPermissions(space);
    }

    @Override
    @Deprecated
    public void removePermission(SpacePermission permission) {
        this.delegate.removePermission(permission);
    }

    @Override
    public boolean hasPermission(String permissionType, @Nullable Space space, @Nullable ConfluenceUser user) {
        return this.delegate.hasPermission(permissionType, space, user);
    }

    @Override
    public boolean hasPermissionNoExemptions(String permissionType, @Nullable Space space, @Nullable ConfluenceUser remoteUser) {
        return this.delegate.hasPermissionNoExemptions(permissionType, space, remoteUser);
    }

    @Override
    public boolean hasAllPermissions(List<String> permissionTypes, @Nullable Space space, @Nullable ConfluenceUser user) {
        return this.delegate.hasAllPermissions(permissionTypes, space, user);
    }

    @Override
    @Deprecated
    public void removeAllUserPermissions(ConfluenceUser user) {
        this.delegate.removeAllUserPermissions(user);
    }

    @Override
    @Deprecated
    public void removeGlobalPermissionForUser(ConfluenceUser user, String permissionType) {
        this.delegate.removeGlobalPermissionForUser(user, permissionType);
    }

    @Override
    @Deprecated
    public void removeAllPermissionsForGroup(String group) {
        this.delegate.removeAllPermissionsForGroup(group);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SpacePermission> getAllPermissionsForGroup(String group) {
        return this.delegate.getAllPermissionsForGroup(group);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SpacePermission> getGlobalPermissions() {
        return this.delegate.getGlobalPermissions();
    }

    @Override
    @Transactional(readOnly=true)
    public List<SpacePermission> getGlobalPermissions(String permissionType) {
        return this.delegate.getGlobalPermissions(permissionType);
    }

    @Override
    public void flushCaches() {
        this.delegate.flushCaches();
    }

    @Override
    public boolean groupHasPermission(String permissionType, @Nullable Space space, String group) {
        return this.delegate.groupHasPermission(permissionType, space, group);
    }

    @Override
    public void createDefaultSpacePermissions(Space space) {
        this.delegate.createDefaultSpacePermissions(space);
    }

    @Override
    public void createPrivateSpacePermissions(Space space) {
        this.delegate.createPrivateSpacePermissions(space);
    }

    @Override
    public boolean hasPermissionForSpace(@Nullable ConfluenceUser user, List permissionTypes, @Nullable Space space) {
        return this.delegate.hasPermissionForSpace(user, permissionTypes, space);
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<Group> getGroupsWithPermissions(@Nullable Space space) {
        return this.delegate.getGroupsWithPermissions(space);
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, Long> getGroupsForPermissionType(String permissionType, Space space) {
        return this.delegate.getGroupsForPermissionType(permissionType, space);
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<ConfluenceUser> getUsersWithPermissions(@Nullable Space space) {
        return this.delegate.getUsersWithPermissions(space);
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, Long> getUsersForPermissionType(String permissionType, Space space) {
        return this.delegate.getUsersForPermissionType(permissionType, space);
    }

    @Override
    public boolean permissionExists(SpacePermission permission) {
        return this.delegate.permissionExists(permission);
    }

    @Override
    @Transactional(readOnly=true)
    public Set<SpacePermission> getDefaultGlobalPermissions() {
        return this.delegate.getDefaultGlobalPermissions();
    }

    @Override
    public boolean isPermittedInReadOnlyAccessMode(String permissionType) {
        return this.delegate.isPermittedInReadOnlyAccessMode(permissionType);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SpacePermission> getPermissionsForUser(ConfluenceUser user, Space space) {
        return this.delegate.getPermissionsForUser(user, space);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SpacePermission> getPermissionsForGroup(String group, Space space) {
        return this.delegate.getPermissionsForGroup(group, space);
    }

    @Override
    @Transactional(readOnly=true)
    public List<SpacePermission> getPermissionsForAnonymousUsers(Space space) {
        return this.delegate.getPermissionsForAnonymousUsers(space);
    }

    @Override
    public boolean groupInheritsPermission(String permissionType, @Nullable Space space, String group) {
        return this.delegate.groupInheritsPermission(permissionType, space, group);
    }

    @Override
    @Deprecated
    public void savePermission(SpacePermission permission) {
        this.delegate.savePermission(permission);
    }

    @Override
    public void savePermission(SpacePermission permission, SpacePermissionContext context) {
        this.delegate.savePermission(permission, context);
    }

    @Override
    public void saveSpacePermissions(@NonNull Space space, Collection<SpacePermission> spacePermissions, SpacePermissionContext context) {
        this.delegate.saveSpacePermissions(space, spacePermissions, context);
    }

    @Override
    public void saveGlobalPermissions(Collection<SpacePermission> spacePermissions, SpacePermissionContext context) {
        this.delegate.saveGlobalPermissions(spacePermissions, context);
    }
}

