/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.security;

import com.atlassian.confluence.impl.security.recovery.RecoveryUtil;
import com.atlassian.confluence.internal.security.DelegatingSpacePermissionManager;
import com.atlassian.confluence.internal.security.SpacePermissionManagerInternal;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RecoveryAwareSpacePermissionManager
extends DelegatingSpacePermissionManager {
    public RecoveryAwareSpacePermissionManager(SpacePermissionManagerInternal delegate) {
        super(delegate);
    }

    @Override
    public boolean hasPermission(String permissionType, @Nullable Space space, @Nullable ConfluenceUser user) {
        if (RecoveryUtil.isRecoveryAdmin(user)) {
            return true;
        }
        return super.hasPermission(permissionType, space, user);
    }

    @Override
    public boolean hasPermissionNoExemptions(String permissionType, @Nullable Space space, @Nullable ConfluenceUser remoteUser) {
        if (RecoveryUtil.isRecoveryAdmin(remoteUser)) {
            return true;
        }
        return super.hasPermissionNoExemptions(permissionType, space, remoteUser);
    }

    @Override
    public boolean hasAllPermissions(List<String> permissionTypes, @Nullable Space space, @Nullable ConfluenceUser user) {
        if (RecoveryUtil.isRecoveryAdmin(user)) {
            return true;
        }
        return super.hasAllPermissions(permissionTypes, space, user);
    }
}

