/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.security;

import com.atlassian.confluence.dmz.security.delegate.ScopesRequestCacheDelegate;
import com.atlassian.confluence.internal.security.DebuggingString;
import com.atlassian.confluence.internal.security.DelegatingSpacePermissionManager;
import com.atlassian.confluence.internal.security.ServiceAccountPermissionManager;
import com.atlassian.confluence.internal.security.SpacePermissionManagerInternal;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopesAwareSpacePermissionManager
extends DelegatingSpacePermissionManager {
    private static final Logger log = LoggerFactory.getLogger(ScopesAwareSpacePermissionManager.class);
    private final ScopesRequestCacheDelegate scopesRequestCacheDelegate;
    private final ServiceAccountPermissionManager serviceAccountPermissionManager;

    public ScopesAwareSpacePermissionManager(SpacePermissionManagerInternal delegate, ScopesRequestCacheDelegate scopesRequestCacheDelegate, ServiceAccountPermissionManager serviceAccountPermissionManager) {
        super(delegate);
        this.scopesRequestCacheDelegate = scopesRequestCacheDelegate;
        this.serviceAccountPermissionManager = serviceAccountPermissionManager;
    }

    @Override
    public boolean hasPermission(String permissionType, @Nullable Space space, @Nullable ConfluenceUser user) {
        DebuggingString permissionCheck = DebuggingString.getPermissionCheckAsString(log, permissionType, space, user);
        if (this.scopesRequestCacheDelegate.isScopePermitted("READ_ALL")) {
            if (!SpacePermission.READ_ALL_SCOPE_SPACE_PERMISSIONS.contains(permissionType)) {
                log.debug("{} User blocked due to READ_ALL scope. PERMISSION DENIED.", (Object)permissionCheck);
                return false;
            }
            log.debug("{} User allowed due to READ_ALL scope. PERMISSION GRANTED.", (Object)permissionCheck);
            return true;
        }
        if (!this.scopesRequestCacheDelegate.hasPermission(permissionType, (Object)space)) {
            if (log.isDebugEnabled()) {
                String scopes = this.scopesRequestCacheDelegate.getRequestCache().map(s -> s.getScopes().toString()).orElse("none");
                log.debug("{} User blocked due to scopes {}. PERMISSION DENIED.", (Object)permissionCheck, (Object)scopes);
            }
            return false;
        }
        if (this.serviceAccountPermissionManager.hasSpacePermission(space, user)) {
            return true;
        }
        return super.hasPermission(permissionType, space, user);
    }

    @Override
    public boolean hasPermissionNoExemptions(String permissionType, @Nullable Space space, @Nullable ConfluenceUser remoteUser) {
        DebuggingString permissionCheck = DebuggingString.getPermissionCheckAsString(log, permissionType, space, remoteUser);
        if (this.scopesRequestCacheDelegate.isScopePermitted("READ_ALL")) {
            if (!SpacePermission.READ_ALL_SCOPE_SPACE_PERMISSIONS.contains(permissionType)) {
                log.debug("{} User blocked due to READ_ALL scope. PERMISSION DENIED.", (Object)permissionCheck);
                return false;
            }
            log.debug("{} User allowed due to READ_ALL scope. PERMISSION GRANTED.", (Object)permissionCheck);
            return true;
        }
        if (!this.scopesRequestCacheDelegate.hasPermission(permissionType, (Object)space)) {
            if (log.isDebugEnabled()) {
                String scopes = this.scopesRequestCacheDelegate.getRequestCache().map(s -> s.getScopes().toString()).orElse("none");
                log.debug("{} User blocked due to scopes {}. PERMISSION DENIED.", (Object)permissionCheck, (Object)scopes);
            }
            return false;
        }
        if (this.serviceAccountPermissionManager.hasSpacePermission(space, remoteUser)) {
            return true;
        }
        return super.hasPermissionNoExemptions(permissionType, space, remoteUser);
    }

    @Override
    public boolean hasAllPermissions(List<String> permissionTypes, @Nullable Space space, @Nullable ConfluenceUser user) {
        if (this.scopesRequestCacheDelegate.isScopePermitted("READ_ALL")) {
            for (String permissionType : permissionTypes) {
                DebuggingString permissionCheck = DebuggingString.getPermissionCheckAsString(log, permissionType, space, user);
                if (!SpacePermission.READ_ALL_SCOPE_SPACE_PERMISSIONS.contains(permissionType)) {
                    log.debug("{} User blocked due to READ_ALL scope. PERMISSION DENIED.", (Object)permissionCheck);
                    return false;
                }
                log.debug("{} User allowed due to READ_ALL scope. PERMISSION GRANTED.", (Object)permissionCheck);
            }
            return true;
        }
        boolean isServiceAccount = this.serviceAccountPermissionManager.isServiceAccount(user);
        for (String permissionType : permissionTypes) {
            DebuggingString permissionCheck = DebuggingString.getPermissionCheckAsString(log, permissionType, space, user);
            if (isServiceAccount) {
                if (this.serviceAccountPermissionManager.hasSpacePermission(space, user, permissionType)) continue;
                log.debug("{} User blocked as service account does not have permissions to space {}. PERMISSION DENIED.", (Object)permissionCheck, (Object)space);
                return false;
            }
            if (this.scopesRequestCacheDelegate.hasPermission(permissionType, (Object)space)) continue;
            if (log.isDebugEnabled()) {
                String scopes = this.scopesRequestCacheDelegate.getRequestCache().map(s -> s.getScopes().toString()).orElse("none");
                log.debug("{} User blocked due to scopes {}. PERMISSION DENIED.", (Object)permissionCheck, (Object)scopes);
            }
            return false;
        }
        return super.hasAllPermissions(permissionTypes, space, user);
    }
}

