/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.security;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.dmz.security.delegate.ScopesRequestCacheDelegate;
import com.atlassian.confluence.impl.user.crowd.serviceaccount.ConfluenceResourceType;
import com.atlassian.confluence.impl.user.crowd.serviceaccount.ServiceAccountUserImpl;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.crowd.embedded.api.service.Resource;
import com.atlassian.crowd.embedded.api.service.ResourceType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceAccountPermissionManager {
    private final Logger log = LoggerFactory.getLogger(ServiceAccountPermissionManager.class);
    private ScopesRequestCacheDelegate scopesRequestCacheDelegate;

    public boolean isServiceAccount(ConfluenceUser user) {
        return user != null && user.isServiceAccount();
    }

    public boolean hasPermission(ConfluenceUser user, Permission permission, Object target) {
        if (target instanceof Space) {
            return this.hasSpacePermission((Space)target, user);
        }
        if (target instanceof ContentEntityObject) {
            return this.hasContentPermission(permission.toString(), (ContentEntityObject)target, user);
        }
        return false;
    }

    public boolean hasSpacePermission(Space space, ConfluenceUser user) {
        return this.hasSpacePermission(space, user, null);
    }

    public boolean hasSpacePermission(Space space, ConfluenceUser user, String permission) {
        if (!this.isServiceAccount(user)) {
            return false;
        }
        boolean hasAccess = false;
        Optional<ServiceAccountUserImpl> optionalUser = ServiceAccountUserImpl.toServiceAccountUserImpl(user);
        if (optionalUser.isEmpty()) {
            return false;
        }
        ServiceAccountUserImpl serviceAccount = optionalUser.get();
        Map<ResourceType, Set<Resource>> resourceRestrictions = serviceAccount.getResourceRestrictions();
        if (resourceRestrictions.isEmpty()) {
            hasAccess = true;
        } else {
            Set resources = resourceRestrictions.entrySet().stream().filter(entry -> ConfluenceResourceType.SPACES.getResourceTypeId().equals(((ResourceType)entry.getKey()).getId())).map(Map.Entry::getValue).findFirst().orElse(null);
            if (resources != null) {
                String spaceKey = String.valueOf(space.getKey());
                for (Resource resource : resources) {
                    if (!resource.getId().equalsIgnoreCase(spaceKey)) continue;
                    hasAccess = true;
                }
            }
        }
        boolean bl = hasAccess = hasAccess && this.scopeHasPermission(permission);
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} OAuth2 client blocked as the service account {} does not have permissions to space {}. PERMISSION DENIED.", (Object)user.getName(), (Object)space.getName());
        }
        return hasAccess;
    }

    public boolean hasContentPermission(String permissionType, ContentEntityObject contentEntityObject, ConfluenceUser user) {
        if (!this.isServiceAccount(user)) {
            return false;
        }
        Optional<ServiceAccountUserImpl> optionalUser = ServiceAccountUserImpl.toServiceAccountUserImpl(user);
        if (optionalUser.isEmpty()) {
            return false;
        }
        ServiceAccountUserImpl serviceAccount = optionalUser.get();
        Map<ResourceType, Set<Resource>> resourceRestrictions = serviceAccount.getResourceRestrictions();
        if (resourceRestrictions.isEmpty()) {
            return this.scopeHasPermission(permissionType);
        }
        Space space = null;
        if (contentEntityObject instanceof Comment) {
            Comment comment = (Comment)contentEntityObject;
            space = comment.getSpace();
        } else if (contentEntityObject instanceof Page) {
            Page page = (Page)contentEntityObject;
            space = page.getSpace();
        } else if (contentEntityObject instanceof BlogPost) {
            BlogPost blogPost = (BlogPost)contentEntityObject;
            space = blogPost.getSpace();
        } else if (contentEntityObject instanceof SpaceContentEntityObject) {
            space = ((SpaceContentEntityObject)contentEntityObject).getSpace();
        }
        if (space != null) {
            return this.hasSpacePermission(space, user, permissionType);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} OAuth2 client blocked as the service account {} does not have permissions to ContentEntityObject {}. PERMISSION DENIED.", (Object)user.getName(), (Object)contentEntityObject.getNameForComparison());
        }
        return false;
    }

    public void setScopesRequestCacheDelegate(ScopesRequestCacheDelegate scopesRequestCacheDelegate) {
        this.scopesRequestCacheDelegate = scopesRequestCacheDelegate;
    }

    private boolean scopeHasPermission(String permission) {
        if (permission == null || permission.isEmpty()) {
            return true;
        }
        Collection<Object> permissionsAllowed = List.of();
        if (this.scopesRequestCacheDelegate.isScopePermitted("WRITE")) {
            permissionsAllowed = SpacePermission.WRITE_SERVICE_ACCOUNT_PERMISSIONS;
        } else if (this.scopesRequestCacheDelegate.isScopePermitted("READ")) {
            permissionsAllowed = SpacePermission.READ_SERVICE_ACCOUNT_PERMISSIONS;
        }
        return permissionsAllowed.contains(permission);
    }
}

