/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.upgrade;

import com.atlassian.confluence.core.persistence.hibernate.HibernateDatabaseCapabilities;
import com.atlassian.confluence.internal.upgrade.SchemaChecker;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;

public class ColumnTypeChecker {
    private final HibernateDatabaseCapabilities hibernateConfig;
    private final JdbcTemplate jdbcTemplate;

    public ColumnTypeChecker(HibernateDatabaseCapabilities hibernateConfig, JdbcTemplate jdbcTemplate) {
        this.hibernateConfig = Objects.requireNonNull(hibernateConfig);
        this.jdbcTemplate = Objects.requireNonNull(jdbcTemplate);
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_SPRING_JDBC"}, justification="All sql queries are created from private variables and private methods, so SQL injection is not possible")
    public String getColumnType(String columnName, String tableName) {
        HashMap result = (HashMap)this.jdbcTemplate.queryForObject(this.getDatabaseDDL(columnName, tableName), (rs, rowNum) -> {
            HashMap<String, String> tmpResult = new HashMap<String, String>();
            tmpResult.put("type", rs.getString("type"));
            tmpResult.put("length", rs.getString("length"));
            tmpResult.put("charUsed", this.hibernateConfig.isOracle() ? rs.getString("charUsed") : null);
            return tmpResult;
        });
        if (result == null || StringUtils.isBlank((CharSequence)((CharSequence)result.get("type")))) {
            return null;
        }
        return this.assembleColumnType((String)result.get("type"), (String)result.get("length"), (String)result.get("charUsed"));
    }

    private String assembleColumnType(String type, String length, String charUsed) {
        if (StringUtils.isBlank((CharSequence)length)) {
            return type;
        }
        if (this.isCharUsedRequired(type) && !StringUtils.isBlank((CharSequence)charUsed)) {
            String formattedCharUsed = "C".equalsIgnoreCase(charUsed) ? "CHAR" : "BYTE";
            return type + "(" + length + " " + formattedCharUsed + ")";
        }
        return type + "(" + length + ")";
    }

    private boolean isCharUsedRequired(String dataType) {
        if (this.hibernateConfig.isOracle() && !StringUtils.isBlank((CharSequence)dataType)) {
            return dataType.toUpperCase().startsWith("CHAR") || dataType.toUpperCase().startsWith("VARCHAR");
        }
        return false;
    }

    private String getDatabaseDDL(String columnName, String tableName) {
        if (this.hibernateConfig.isH2()) {
            return this.getH2DDL(columnName, tableName);
        }
        if (this.hibernateConfig.isMySql()) {
            return this.getMySqlDDL(columnName, tableName);
        }
        if (this.hibernateConfig.isOracle()) {
            return this.getOracleDDL(columnName, tableName);
        }
        if (this.hibernateConfig.isPostgreSql()) {
            return this.getPostgresDDL(columnName, tableName);
        }
        if (this.hibernateConfig.isSqlServer()) {
            return this.getSqlServerDDL(columnName, tableName);
        }
        throw new UnsupportedOperationException("Unsupported database type");
    }

    private String getSqlServerDDL(String columnName, String tableName) {
        return "SELECT DATA_TYPE AS type, CHARACTER_MAXIMUM_LENGTH AS length \nFROM INFORMATION_SCHEMA.COLUMNS \nWHERE LOWER(TABLE_NAME) = LOWER('" + tableName + "')  AND LOWER(COLUMN_NAME) = LOWER('" + columnName + "')  AND TABLE_SCHEMA = '" + this.getSchema() + "';";
    }

    private String getPostgresDDL(String columnName, String tableName) {
        return "SELECT DATA_TYPE AS type, CHARACTER_MAXIMUM_LENGTH as length \nFROM INFORMATION_SCHEMA.COLUMNS \nWHERE LOWER(TABLE_NAME) = LOWER('" + tableName + "')  AND LOWER(COLUMN_NAME) = LOWER('" + columnName + "')  AND TABLE_SCHEMA = '" + this.getSchema() + "';";
    }

    private String getOracleDDL(String columnName, String tableName) {
        return "SELECT DATA_TYPE AS type, CHAR_LENGTH as length, CHAR_USED as charUsed \nFROM ALL_TAB_COLUMNS \nWHERE LOWER(TABLE_NAME) = LOWER('" + tableName + "')  AND LOWER(COLUMN_NAME) = LOWER('" + columnName + "')  AND OWNER = '" + this.getSchema() + "'";
    }

    private String getMySqlDDL(String columnName, String tableName) {
        return "SELECT DATA_TYPE AS type, CHARACTER_MAXIMUM_LENGTH as length \nFROM INFORMATION_SCHEMA.COLUMNS \nWHERE LOWER(TABLE_NAME) = LOWER('" + tableName + "')  AND LOWER(COLUMN_NAME) = LOWER('" + columnName + "')  AND TABLE_SCHEMA = '" + this.getSchema() + "';";
    }

    private String getH2DDL(String columnName, String tableName) {
        return "SELECT TYPE_NAME AS type, CHARACTER_MAXIMUM_LENGTH as length \nFROM INFORMATION_SCHEMA.COLUMNS \nWHERE LOWER(TABLE_NAME) = LOWER('" + tableName + "')  AND LOWER(COLUMN_NAME) = LOWER('" + columnName + "');";
    }

    private String getSchema() {
        return new SchemaChecker(this.hibernateConfig, this.jdbcTemplate).getSchema();
    }
}

