/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.upgrade;

import com.atlassian.confluence.core.persistence.hibernate.HibernateDatabaseCapabilities;
import java.util.List;
import java.util.Objects;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class SchemaChecker {
    private final HibernateDatabaseCapabilities hibernateConfig;
    private final JdbcTemplate jdbcTemplate;

    public SchemaChecker(HibernateDatabaseCapabilities hibernateConfig, JdbcTemplate jdbcTemplate) {
        this.hibernateConfig = Objects.requireNonNull(hibernateConfig);
        this.jdbcTemplate = Objects.requireNonNull(jdbcTemplate);
    }

    public String getSchema() {
        if (this.hibernateConfig.isH2()) {
            return null;
        }
        if (this.hibernateConfig.isMySql()) {
            return this.getMySqlDDL();
        }
        if (this.hibernateConfig.isOracle()) {
            return this.getOracleDDL();
        }
        if (this.hibernateConfig.isPostgreSql()) {
            return this.getPostgresDDL();
        }
        if (this.hibernateConfig.isSqlServer()) {
            return this.getSqlServerDDL();
        }
        throw new UnsupportedOperationException("Unsupported database type");
    }

    private String getSqlServerDDL() {
        List schemaNameList = this.jdbcTemplate.queryForList("SELECT SCHEMA_NAME();", String.class);
        if (schemaNameList.size() != 1) {
            throw new IllegalStateException("Unable to determine schema name. Expected one value, but received " + schemaNameList.size() + " values: " + String.join((CharSequence)", ", schemaNameList));
        }
        return (String)schemaNameList.get(0);
    }

    private String getPostgresDDL() {
        try {
            String schemaName = (String)this.jdbcTemplate.queryForObject("SELECT current_schema();", String.class);
            if (schemaName == null) {
                throw new IllegalStateException("Unable to determine schema name. Expected default schema name, but [SELECT current_schema();] query returned NULL");
            }
            return schemaName;
        }
        catch (IncorrectResultSizeDataAccessException e) {
            throw new IllegalStateException("Unable to determine schema name. Expected one value, but [SELECT current_schema();] query returned more than one record", e);
        }
    }

    private String getOracleDDL() {
        try {
            String schemaName = (String)this.jdbcTemplate.queryForObject("SELECT SYS_CONTEXT('USERENV','CURRENT_SCHEMA') FROM DUAL", String.class);
            if (schemaName == null) {
                throw new IllegalStateException("Unable to determine schema name. Expected default schema name, but [SELECT SYS_CONTEXT('USERENV','CURRENT_SCHEMA') FROM DUAL] query returned NULL");
            }
            return schemaName;
        }
        catch (IncorrectResultSizeDataAccessException e) {
            throw new IllegalStateException("Unable to determine schema name. Expected one value, but [SELECT SYS_CONTEXT('USERENV','CURRENT_SCHEMA') FROM DUAL] query returned more than one record", e);
        }
    }

    private String getMySqlDDL() {
        try {
            String schemaName = (String)this.jdbcTemplate.queryForObject("SELECT DATABASE();", String.class);
            if (schemaName == null) {
                throw new IllegalStateException("Unable to determine schema name. Expected default schema name, but [SELECT DATABASE()] query returned NULL");
            }
            return schemaName;
        }
        catch (IncorrectResultSizeDataAccessException e) {
            throw new IllegalStateException("Unable to determine schema name. Expected one value, but [SELECT DATABASE()] query returned more than one record", e);
        }
    }
}

