/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.upgrade.index;

import com.atlassian.confluence.core.persistence.hibernate.HibernateDatabaseCapabilities;
import com.atlassian.confluence.internal.upgrade.SchemaChecker;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import org.springframework.jdbc.core.JdbcTemplate;

public class IndexChecker {
    private final HibernateDatabaseCapabilities hibernateConfig;
    private final JdbcTemplate jdbcTemplate;

    public IndexChecker(HibernateDatabaseCapabilities hibernateConfig, JdbcTemplate jdbcTemplate) {
        this.hibernateConfig = Objects.requireNonNull(hibernateConfig);
        this.jdbcTemplate = Objects.requireNonNull(jdbcTemplate);
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_SPRING_JDBC"}, justification="All sql queries are created from private variables and private methods, so SQL injection is not possible")
    public boolean indexExists(String indexName, String tableName) {
        Integer indexCount = (Integer)this.jdbcTemplate.queryForObject(this.getDatabaseDDL(indexName, tableName), Integer.class);
        return indexCount != null && indexCount > 0;
    }

    private String getDatabaseDDL(String indexName, String tableName) {
        if (this.hibernateConfig.isH2()) {
            return this.getH2DDL(indexName, tableName);
        }
        if (this.hibernateConfig.isMySql()) {
            return this.getMySqlDDL(indexName, tableName);
        }
        if (this.hibernateConfig.isOracle()) {
            return this.getOracleDDL(indexName, tableName);
        }
        if (this.hibernateConfig.isPostgreSql()) {
            return this.getPostgresDDL(indexName, tableName);
        }
        if (this.hibernateConfig.isSqlServer()) {
            return this.getSqlServerDDL(indexName, tableName);
        }
        throw new UnsupportedOperationException("Unsupported database type");
    }

    private String getSqlServerDDL(String indexName, String tableName) {
        return "SELECT COUNT(*) \nFROM sys.indexes i \nJOIN sys.tables t ON i.object_id = t.object_id \nJOIN sys.schemas s ON s.schema_id = t.schema_id \nWHERE i.name = '" + indexName + "' AND t.name = '" + tableName + "' AND s.name = '" + this.getSchema() + "';";
    }

    private String getPostgresDDL(String indexName, String tableName) {
        return "SELECT COUNT(*) FROM pg_indexes\nWHERE indexname = '" + indexName.toLowerCase() + "' \nAND tablename = '" + tableName.toLowerCase() + "' \nAND schemaname = '" + this.getSchema() + "';";
    }

    private String getOracleDDL(String indexName, String tableName) {
        return "SELECT COUNT(*)\nFROM user_indexes\nWHERE index_name = '" + indexName.toUpperCase() + "' AND table_name = '" + tableName.toUpperCase() + "' AND table_owner = '" + this.getSchema() + "'";
    }

    private String getMySqlDDL(String indexName, String tableName) {
        return "SELECT COUNT(*)\nFROM INFORMATION_SCHEMA.STATISTICS\nWHERE TABLE_NAME = '" + tableName + "' AND INDEX_NAME = '" + indexName + "' AND TABLE_SCHEMA = '" + this.getSchema() + "';";
    }

    private String getH2DDL(String indexName, String tableName) {
        return "SELECT COUNT(*) FROM INFORMATION_SCHEMA.INDEXES\nWHERE INDEX_NAME = '" + indexName.toUpperCase() + "' \nAND TABLE_NAME = '" + tableName.toUpperCase() + "';";
    }

    private String getSchema() {
        return new SchemaChecker(this.hibernateConfig, this.jdbcTemplate).getSchema();
    }
}

