/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.web.filter.spring;

import com.atlassian.annotations.security.UnrestrictedAccess;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;
import org.springframework.web.context.request.async.WebAsyncUtils;

@UnrestrictedAccess
public class IgnoreWebAsyncManagerFilter
implements Filter {
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest) {
            servletRequest = new HttpServletRequestWrapper(this, (HttpServletRequest)servletRequest){

                public void setAttribute(String name, Object o) {
                    if (!WebAsyncUtils.WEB_ASYNC_MANAGER_ATTRIBUTE.equals(name)) {
                        super.setAttribute(name, o);
                    }
                }
            };
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

