/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.json.jsonator;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.datetime.DateFormatterFactory;
import com.atlassian.confluence.core.service.ValidationError;
import com.atlassian.confluence.json.jsonator.AttachmentJsonator;
import com.atlassian.confluence.json.jsonator.BreadcrumbJsonator;
import com.atlassian.confluence.json.jsonator.ContentMetadataJsonator;
import com.atlassian.confluence.json.jsonator.DefaultJsonator;
import com.atlassian.confluence.json.jsonator.DocumentationLinkJsonator;
import com.atlassian.confluence.json.jsonator.EntityJsonator;
import com.atlassian.confluence.json.jsonator.GsonJsonator;
import com.atlassian.confluence.json.jsonator.Gsonable;
import com.atlassian.confluence.json.jsonator.I18nJsonator;
import com.atlassian.confluence.json.jsonator.Jsonator;
import com.atlassian.confluence.json.jsonator.JsonatorFactory;
import com.atlassian.confluence.json.jsonator.SearchResultJsonator;
import com.atlassian.confluence.json.jsonator.ValidationAwareJsonator;
import com.atlassian.confluence.json.jsonator.ValidationErrorJsonator;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.thumbnail.ThumbnailManager;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.user.UserPreferencesAccessor;
import com.atlassian.confluence.user.UserProfilePictureAccessor;
import com.atlassian.confluence.util.breadcrumbs.Breadcrumb;
import com.atlassian.confluence.util.i18n.DocumentationBean;
import com.atlassian.confluence.util.i18n.DocumentationLink;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.i18n.Message;
import com.atlassian.user.Entity;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.struts2.interceptor.ValidationAware;

public class DefaultJsonatorFactory
implements JsonatorFactory {
    private final FormatSettingsManager formatSettingsManager;
    private final LocaleManager localeManager;
    private final ContextPathHolder contextPathHolder;
    private final I18NBeanFactory userI18NBeanFactory;
    private final UserProfilePictureAccessor userProfilePictureAccessor;
    private final DocumentationBean docBean;
    private final UserPreferencesAccessor userPreferencesAccessor;
    private final DateFormatterFactory dateFormatterFactory;
    private final ThumbnailManager thumbnailManager;

    public DefaultJsonatorFactory(FormatSettingsManager formatSettingsManager, LocaleManager localeManager, ContextPathHolder contextPathHolder, I18NBeanFactory userI18NBeanFactory, UserProfilePictureAccessor userProfilePictureAccessor, DocumentationBean docBean, UserPreferencesAccessor userPreferencesAccessor, DateFormatterFactory dateFormatterFactory, ThumbnailManager thumbnailManager) {
        this.formatSettingsManager = formatSettingsManager;
        this.localeManager = localeManager;
        this.contextPathHolder = contextPathHolder;
        this.userI18NBeanFactory = userI18NBeanFactory;
        this.userProfilePictureAccessor = userProfilePictureAccessor;
        this.docBean = docBean;
        this.userPreferencesAccessor = userPreferencesAccessor;
        this.dateFormatterFactory = dateFormatterFactory;
        this.thumbnailManager = thumbnailManager;
    }

    public Jsonator<?> createJsonator() {
        return new DefaultJsonator(this.buildJsonators());
    }

    private Map<Class<?>, Jsonator<?>> buildJsonators() {
        LinkedHashMap jsonators = new LinkedHashMap();
        jsonators.put(Attachment.class, new AttachmentJsonator(this.contextPathHolder, this.thumbnailManager));
        jsonators.put(ContentEntityObject.class, new ContentMetadataJsonator(this.userI18NBeanFactory, this.dateFormatterFactory));
        jsonators.put(Entity.class, new EntityJsonator(this.userProfilePictureAccessor));
        jsonators.put(ValidationError.class, new ValidationErrorJsonator(this.userI18NBeanFactory));
        jsonators.put(Message.class, new I18nJsonator(this.userI18NBeanFactory.getI18NBean()));
        jsonators.put(DocumentationLink.class, new DocumentationLinkJsonator(this.docBean));
        jsonators.put(ValidationAware.class, new ValidationAwareJsonator());
        jsonators.put(Breadcrumb.class, new BreadcrumbJsonator(this.contextPathHolder, this.userI18NBeanFactory));
        jsonators.put(SearchResult.class, new SearchResultJsonator(this.contextPathHolder, this.userI18NBeanFactory, this.userPreferencesAccessor, this.formatSettingsManager, this.localeManager));
        jsonators.put(Gsonable.class, new GsonJsonator());
        return jsonators;
    }
}

