/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.labels;

import com.atlassian.confluence.labels.DisplayableLabel;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.confluence.util.UrlUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CombinedLabel
implements DisplayableLabel {
    public static final String ADD_SEPARATOR = "+";
    private String name;
    private String urlTail;
    private String realTitle;
    private boolean realTitleSafeForUrl;

    public CombinedLabel(List<Label> labels) {
        this.init(labels);
    }

    private void init(List<Label> labels) {
        this.realTitleSafeForUrl = true;
        StringBuilder name = new StringBuilder();
        StringBuilder realTitle = new StringBuilder();
        for (Label label : labels) {
            String title = DisplayableLabel.forCurrentUser(label).getDisplayTitle();
            if (!name.isEmpty()) {
                name.append(ADD_SEPARATOR);
                realTitle.append(ADD_SEPARATOR);
            }
            name.append(label.getName());
            realTitle.append(title);
            if (UrlUtils.isSafeTitleForUrl(title)) continue;
            this.realTitleSafeForUrl = false;
        }
        this.name = name.toString();
        this.realTitle = realTitle.toString();
        this.urlTail = this.realTitleSafeForUrl ? this.realTitle : "ids=" + LabelUtil.joinIds(labels, "&ids=");
    }

    @Override
    @Deprecated(since="9.3", forRemoval=true)
    public boolean isRealTitleSafeForUrl() {
        return this.realTitleSafeForUrl;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUrlPath() {
        if (this.realTitleSafeForUrl) {
            return "/label/" + this.urlTail;
        }
        return "/labels/viewlabel.action?" + this.urlTail;
    }

    @Override
    public String getUrlPath(String spaceKey) {
        if (StringUtils.isBlank((CharSequence)spaceKey)) {
            return this.getUrlPath();
        }
        if (this.realTitleSafeForUrl) {
            return "/label/" + spaceKey + "/" + this.urlTail;
        }
        return "/labels/viewlabel.action?key=" + spaceKey + "&" + this.urlTail;
    }

    @Override
    public String getDisplayTitle() {
        return this.realTitle;
    }
}

