/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.labels;

import com.atlassian.confluence.labels.DisplayableLabel;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.LabelUrlBuilder;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.Comparator;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

final class DisplayableLabelWrapper
implements DisplayableLabel,
Comparable<DisplayableLabelWrapper> {
    private final Label label;
    private final ConfluenceUser currentUser;

    DisplayableLabelWrapper(Label label, @Nullable ConfluenceUser currentUser) {
        this.label = label;
        this.currentUser = currentUser;
    }

    private Label getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.label.getName();
    }

    @Override
    public String getDisplayTitle() {
        return LabelParser.render(this.label, this.currentUser);
    }

    @Override
    public String getUrlPath() {
        return this.createUrlBuilder().buildDisplayUrl();
    }

    @Override
    public String getUrlPath(String spaceKey) {
        return this.createUrlBuilder().currentSpaceKey(spaceKey).buildDisplayUrl();
    }

    private LabelUrlBuilder createUrlBuilder() {
        return LabelUrlBuilder.builder().id(this.label.getId()).name(this.label.getName()).namespace(this.label.getNamespace().getPrefix()).owner(this.label.getOwner()).currentUser(this.currentUser);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisplayableLabelWrapper that = (DisplayableLabelWrapper)o;
        return Objects.equals(this.label, that.label);
    }

    public int hashCode() {
        return Objects.hashCode(this.label);
    }

    @Override
    public int compareTo(DisplayableLabelWrapper other) {
        return Comparator.comparing(DisplayableLabelWrapper::getLabel).compare(this, other);
    }
}

