/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.labels;

import com.atlassian.confluence.core.AnnotatedEntityObject;
import com.atlassian.confluence.labels.DisplayableLabel;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.text.Collator;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NamedQueries(value={@NamedQuery(name="confluence.labelling_findMostPopular", query="select label, CAST(count(1) AS integer)\nfrom Labelling as labelling\njoin labelling.label as label\njoin labelling.content as content\nwhere\n    label.namespace = :namespace AND\n    content.contentStatus = 'current'\ngroup by label, labelling.label.namespace, labelling.label.owningUser, labelling.label.name, labelling.label.lastModificationDate, labelling.label.creationDate\norder by CAST(count(1) AS integer) DESC"), @NamedQuery(name="confluence.labelling_findMostPopularBySpace", query="        select label, CAST(count(1) AS integer)\n        from\n            Labelling as labelling\n        join\n            labelling.label as label\n        join\n            labelling.content as content\n        where\n            label.namespace = :namespace and\n            content.contentStatus = 'current' and\n            content.space.lowerKey = :spaceKey\n        group by\n            label.id,\n            label.namespace,\n            label.owningUser,\n            label.name,\n            label.lastModificationDate,\n            label.creationDate\n        order by\n            CAST(count(1) AS integer) DESC"), @NamedQuery(name="confluence.labelling_findRecentlyUsedUserLabels", query="select labelling from Label as label, Labelling as labelling\n        where label.owningUser.lowerName = :lowerUsername\n        and label.namespace = 'my'\n        and labelling.label = label\n        and labelling.content.contentStatus != 'deleted'\n        order by labelling.lastModificationDate desc"), @NamedQuery(name="confluence.labelling_findRecentlyUsed", query="select labelling from Labelling as labelling, Label as label\n        where labelling.label = label\n        and label.namespace = 'global'\n        and labelling.content.contentStatus != 'deleted'\n        order by labelling.lastModificationDate desc, labelling.id desc"), @NamedQuery(name="confluence.labelling_findRecentlyUsedBySpace", query="select\n            lc\n        from\n            Label as l,\n            Labelling as lc,\n            SpaceContentEntityObject as sceo,\n            Space space\n        where\n            l = lc.label and\n            lc.content = sceo and\n            sceo.space = space and\n            space.lowerKey = :spaceKey and\n            l.namespace = 'global' and\n            lc.content.contentStatus != 'deleted'\n        order by\n            lc.lastModificationDate desc"), @NamedQuery(name="confluence.label_findSingleDegreeSeparationFromContent", query="select\n            distinct label,\n            CAST(count(labelling3.label) AS integer)\n        from\n            Label as label,\n            Labelling as labelling1,\n            Labelling as labelling2,\n            Labelling as labelling3\n        where\n            labelling1.labelableId = :contentID and\n            labelling1.label = labelling2.label and\n            labelling2.labelableId = labelling3.labelableId and\n            labelling2.labelableType = labelling3.labelableType and\n            labelling3.label = label and\n            label.namespace = 'global'\n        group by\n            labelling3.label,\n            label,\n            label.namespace,\n            label.name,\n            label.owningUser,\n            label.creationDate,\n            label.lastModificationDate\n        order by\n            CAST(count(labelling3.label) AS integer) desc"), @NamedQuery(name="confluence.label_findSingleDegreeSeparationFromContentBySpace", query="select\n            distinct label,\n            CAST(count(labelling3.label) AS integer)\n        from\n            Label as label,\n            Labelling as labelling1,\n            Labelling as labelling2,\n            SpaceContentEntityObject as sceo,\n            Space as space,\n            Labelling as labelling3\n            left join labelling3.content as content\n        where\n            labelling1.content.id = :contentID and\n            labelling1.label = labelling2.label and\n            labelling2.content.id = labelling3.content.id and\n            (content = sceo or content.containerContent = sceo) and\n            sceo.space = space and\n            space.lowerKey = :spaceKey and\n            labelling3.label = label and\n            label.namespace = 'global'\n        group by\n            labelling3.label,\n            label,\n            label.namespace,\n            label.name,\n            label.owningUser,\n            label.creationDate,\n            label.lastModificationDate\n        order by\n            CAST(count(labelling3.label) AS integer) desc"), @NamedQuery(name="confluence.label_findSingleDegreeSeparationFromLabel", query="select\n            distinct label,\n            CAST(count(labelling2.label) AS integer)\n        from\n            Label as label,\n            Labelling as labelling1,\n            Labelling as labelling2\n        where\n            labelling1.label.id = :labelID and\n            labelling1.labelableId = labelling2.labelableId and\n            labelling1.labelableType = labelling2.labelableType and\n            labelling2.label.id != :labelID and\n            labelling2.label = label and\n            label.namespace = 'global'\n        group by\n            labelling2.label,\n            label,\n            label.namespace,\n            label.name,\n            label.owningUser,\n            label.creationDate,\n            label.lastModificationDate\n        order by\n            CAST(count(labelling2.label) AS integer) desc"), @NamedQuery(name="confluence.label_findSingleDegreeSeparationFromLabelBySpace", query="select\n            distinct label,\n            CAST(count(labelling2.label) AS integer)\n        from\n            Label as label,\n            Labelling as labelling1,\n            Labelling as labelling2,\n            SpaceContentEntityObject as sceo,\n            Space as space\n        where\n            labelling1.label.id = :labelID and\n            labelling1.content = labelling2.content and\n            labelling2.label.id != :labelID and\n            labelling2.content = sceo and\n            sceo.space = space and\n            space.lowerKey = :spaceKey and\n            labelling2.label = label and\n            label.namespace = 'global'\n        group by\n            labelling2.label,\n            label,\n            label.namespace,\n            label.name,\n            label.owningUser,\n            label.creationDate,\n            label.lastModificationDate\n        order by\n            CAST(count(labelling2.label) AS integer) desc"), @NamedQuery(name="confluence.label_findLabellingDetailsForLabelsWithType", query="select\n            labelling.labelableId,\n            labelling.labelableType\n        from\n            Label label,\n            Labelling labelling\n        where\n            labelling.label = label and\n            labelling.labelableType = :labelableType and\n            label in (:labels)\n        group by\n            labelling.labelableId,\n            labelling.labelableType\n        having\n            CAST(count(labelling.labelableId) AS integer) = :labelCount\n        order by\n            labelling.labelableId"), @NamedQuery(name="confluence.label_findLabellingDetailsForLabelsWithAnyType", query="select\n            labelling.labelableId,\n            labelling.labelableType\n        from\n            Label label,\n            Labelling labelling\n        where\n            labelling.label = label and\n            label in (:labels)\n        group by\n            labelling.labelableId,\n            labelling.labelableType\n        having\n            CAST(count(labelling.labelableId) AS integer) = :labelCount\n        order by\n            labelling.labelableId"), @NamedQuery(name="confluence.label_findAllContentForAllLabels", query="select\n            ceo.id\n        from\n            Label label,\n            Labelling labelling,\n            ContentEntityObject ceo\n        where\n            labelling.content = ceo and\n            labelling.label = label and\n            label in (:labels)\n        group by\n            ceo.id,\n            ceo.lastModificationDate\n        having\n            CAST(count(ceo) AS integer) = :labelCount\n        order by\n            ceo.lastModificationDate"), @NamedQuery(name="confluence.label_findContentForAllLabels", query="select\n            ceo.id\n        from\n            Label label,\n            Labelling labelling,\n            ContentEntityObject ceo\n        where\n            labelling.content = ceo and\n            ceo.contentStatus != 'deleted' and\n            labelling.label = label and\n            label in (:labels)\n        group by\n            ceo.id,\n            ceo.lastModificationDate\n        having\n            CAST(count(ceo) AS integer) = :labelCount\n        order by\n            ceo.lastModificationDate"), @NamedQuery(name="confluence.label_findContentInSpacesForAllLabels", query="select\n            ceo.id\n        from\n            Label label,\n            Labelling labelling,\n            SpaceContentEntityObject ceo,\n            Space space\n        where\n            labelling.content = ceo and\n            ceo.contentStatus != 'deleted' and\n            ceo.space = space and\n            space.lowerKey in (:spaceKeys) and\n            labelling.label = label and\n            label in (:labels)\n        group by\n            ceo.id,\n            ceo.lastModificationDate\n        having\n            CAST(count(ceo) AS integer) = :labelCount\n        order by\n            ceo.lastModificationDate"), @NamedQuery(name="confluence.label_findSpacesWithLabel", query="select\n            distinct space\n        from\n            Space space,\n            Labelling labelling,\n            Label label\n        where\n            space.description = labelling.content and\n            labelling.label = label and\n            label.id = :labelID"), @NamedQuery(name="confluence.label_unused", query="select\n            distinct label\n        from\n            Label label\n        where\n            label not in (\n                select\n                    distinct labelling.label\n                from\n                    Labelling labelling\n            )"), @NamedQuery(name="confluence.label_findFavouriteSpaces", query="select\n            distinct space\n        from\n            Space space,\n            Labelling labelling,\n            Label label\n        where\n            space.description = labelling.content and\n            labelling.label = label and\n            (label.name = 'favourite' or label.name = 'favorite') and\n            label.owningUser.lowerName = :lowerOwnerName and\n            label.namespace = 'my'\n        order by\n            space.name"), @NamedQuery(name="confluence.label_findAllUserLabelledContent", query="select labelling\n        from\n            Label label,\n            Labelling labelling\n        where\n            label = labelling.label and\n            label.owningUser.lowerName = :lowerUsername and\n            label.namespace = 'my'"), @NamedQuery(name="confluence.label_findGlobalLabelsByNamePrefix", query="from\n            Label label\n        where\n            label.name like :prefix and\n            label.namespace = 'global'\n        order by\n            label.name"), @NamedQuery(name="confluence.label_findTeamLabelsByNamePrefix", query="from\n            Label label\n        where\n            label.name like :prefix and\n            label.namespace = 'team'\n        order by\n            label.name")})
@Entity
@Table(name="LABEL", indexes={@Index(name="l_name_idx", columnList="NAME"), @Index(name="l_owner_idx", columnList="OWNER"), @Index(name="l_namespace_idx", columnList="NAMESPACE")})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Access(value=AccessType.PROPERTY)
@Proxy(lazy=false)
public class Label
extends AnnotatedEntityObject
implements Comparable<Label>,
Serializable,
DisplayableLabel {
    private static final Logger log = LoggerFactory.getLogger(Label.class);
    static final String FAVOURITE_LABEL = "favourite";
    static final String FAVOURITE_LABEL_ALT = "favorite";
    @Column(name="NAME")
    @Access(value=AccessType.FIELD)
    private String name;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="OWNER", foreignKey=@ForeignKey(name="FK_LABEL_OWNER"))
    @Target(value=ConfluenceUserImpl.class)
    @Access(value=AccessType.FIELD)
    private ConfluenceUser owningUser;
    private Namespace namespace;

    public Label() {
        this(null);
    }

    public Label(String name) {
        this(name, Namespace.GLOBAL);
    }

    public Label(String name, Namespace namespace) {
        this(name, namespace, (ConfluenceUser)null);
    }

    public Label(String name, String namespace) {
        this(name, namespace, (ConfluenceUser)null);
    }

    public Label(String name, String namespace, ConfluenceUser owner) {
        this(name, Namespace.getNamespace(namespace), owner);
    }

    public Label(String name, Namespace namespace, @Nullable ConfluenceUser owner) {
        this.name = name != null ? name.toLowerCase() : null;
        this.namespace = namespace;
        this.owningUser = owner;
    }

    @Id
    @Column(name="LABELID")
    @GeneratedValue(generator="resettable-hilo-v5")
    @GenericGenerator(name="resettable-hilo-v5", strategy="com.atlassian.confluence.impl.hibernate.ResettableTableHiLoGeneratorV5")
    public long getId() {
        return super.getId();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Deprecated
    @Transient
    public @Nullable String getOwner() {
        if (this.owningUser != null) {
            return this.owningUser.getName();
        }
        return null;
    }

    @Transient
    public @Nullable ConfluenceUser getOwnerUser() {
        return this.owningUser;
    }

    @Column(name="NAMESPACE")
    @Type(type="com.atlassian.confluence.labels.persistence.dao.hibernate.NamespaceUserType")
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Deprecated(since="9.3", forRemoval=true)
    @Transient
    public String getType() {
        return "label:" + this.getNamespace().toString();
    }

    private void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Label label = (Label)o;
        if (!Objects.equals(this.namespace, label.namespace)) {
            return false;
        }
        if (!Objects.equals(this.name, label.name)) {
            return false;
        }
        String owner = this.getOwner();
        if (owner != null) {
            return owner.equalsIgnoreCase(label.getOwner());
        }
        return label.getOwner() == null;
    }

    public int hashCode() {
        int result = 0;
        result = 29 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
        result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 29 * result + (this.owningUser != null ? this.owningUser.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(Label otherlabel) {
        Collator collator = Collator.getInstance();
        int typeComparison = collator.compare(this.getNamespace().toString(), otherlabel.getNamespace().toString());
        if (typeComparison != 0) {
            return typeComparison;
        }
        return collator.compare(this.getName(), otherlabel.getName());
    }

    @Override
    @Deprecated(since="9.3", forRemoval=true)
    @Transient
    public String getRealTitle() {
        return this.displayableLabel().getRealTitle();
    }

    @Override
    @Deprecated(since="9.3", forRemoval=true)
    @Transient
    public String getDisplayTitle() {
        return this.displayableLabel().getDisplayTitle();
    }

    @Override
    @Deprecated(since="9.3", forRemoval=true)
    @Transient
    public boolean isRealTitleSafeForUrl() {
        return this.displayableLabel().isRealTitleSafeForUrl();
    }

    @Override
    @Deprecated(since="9.3", forRemoval=true)
    @Transient
    public String getUrlPath() {
        return this.displayableLabel().getUrlPath();
    }

    @Override
    @Deprecated(since="9.3", forRemoval=true)
    public String getUrlPath(String spaceKey) {
        return this.displayableLabel().getUrlPath(spaceKey);
    }

    @Transient
    private DisplayableLabel displayableLabel() {
        return DisplayableLabel.forCurrentUser(this);
    }

    @Deprecated
    @Transient
    public boolean isNew() {
        return this.getCreationDate() == null || this.getCreationDate().equals(this.getLastModificationDate());
    }

    @Transient
    public boolean isPersistent() {
        return this.getId() != 0L;
    }

    public boolean isVisibleTo(@Nullable String username) {
        if (this.namespace == null) {
            log.error("Label {} has null namespace", (Object)this.getId());
            return true;
        }
        if ("public".equals(this.namespace.getVisibility())) {
            return true;
        }
        if ("owner".equals(this.namespace.getVisibility())) {
            return username != null && username.equals(this.getOwner());
        }
        return false;
    }

    @Deprecated(since="9.3", forRemoval=true)
    @Transient
    public String toStringWithOwnerPrefix() {
        return LabelParser.renderWithOwnerPrefix(this);
    }

    public String toString() {
        return this.getDisplayTitle();
    }

    @Deprecated(since="9.3", forRemoval=true)
    @Transient
    public String toStringWithNamespace() {
        return LabelParser.renderWithNamespace(this);
    }

    @Transient
    public boolean isTeamLabel() {
        return Namespace.isTeam(this);
    }

    public static boolean containsFavouriteLabel(Collection<Label> labels, ConfluenceUser user) {
        return Set.of(FAVOURITE_LABEL, FAVOURITE_LABEL_ALT).stream().anyMatch(labelName -> labels.contains(new Label((String)labelName, Namespace.PERSONAL, user)));
    }
}

