/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.labels;

import com.atlassian.confluence.core.AnnotatedEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.EditableLabelable;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelableType;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.Objects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Target;

@NamedQueries(value={@NamedQuery(name="confluence.label_findSpacesContainingContentWithLabel", query="select\n            s\n        from\n            Space s,\n            Labelling lc,\n            SpaceContentEntityObject sceo\n        where\n            sceo.space = s and\n            lc.content = sceo\n        and\n            lc.label.id = :labelID"), @NamedQuery(name="confluence.label_findLabellingsForLabel", query="select labelling\nfrom Labelling labelling\nwhere labelling.label.id = :labelID\norder by labelling.lastModificationDate desc"), @NamedQuery(name="confluence.label_findContentForLabelAndSpace", query="select\n            sceo,\n            labelling.lastModificationDate\n        from\n            SpaceContentEntityObject sceo,\n            Labelling labelling,\n            Space space\n        where\n            sceo = labelling.content and\n            labelling.label.id = :labelID and\n            sceo.space = space and\n            space.lowerKey = :spaceKey and\n            sceo.contentStatus = 'current'\n        order by\n            labelling.lastModificationDate desc"), @NamedQuery(name="confluence.label_findFavouriteLabellingsByContentIds", query="from\n            Labelling labelling\n        where\n            labelling.label.namespace = 'my' and\n            (labelling.label.name = 'favourite' or labelling.label.name = 'favorite') and\n            labelling.label.owningUser.key = :userKey and\n            labelling.content.id in (:contentIds)\n        order by\n            labelling.creationDate desc")})
@Entity
@Table(name="CONTENT_LABEL", indexes={@Index(name="cl_labelid_idx", columnList="LABELID"), @Index(name="cl_contentid_idx", columnList="CONTENTID"), @Index(name="cl_pagetemplateid_idx", columnList="PAGETEMPLATEID"), @Index(name="cl_owner_idx", columnList="OWNER"), @Index(name="cl_lastmoddate_idx", columnList="LASTMODDATE"), @Index(name="cl_labelable_idx", columnList="LABELABLEID,LABELABLETYPE")})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Access(value=AccessType.PROPERTY)
@Proxy(lazy=false)
public class Labelling
extends AnnotatedEntityObject
implements Serializable {
    private ContentEntityObject content;
    private PageTemplate pageTemplate;
    private Label label;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="OWNER", foreignKey=@ForeignKey(name="FK_CONTENT_LABEL_OWNER"))
    @Target(value=ConfluenceUserImpl.class)
    @Access(value=AccessType.FIELD)
    private ConfluenceUser owningUser;
    private String labelableType;
    private Long labelableId;

    public Labelling(Label label, EditableLabelable labelable, ConfluenceUser user) {
        if (!label.isPersistent()) {
            throw new IllegalStateException("A label must be persistent to use it to label content.");
        }
        this.label = label;
        this.owningUser = user;
        this.setLabelable(labelable);
        this.verifyUnion();
    }

    public Labelling() {
    }

    @Id
    @Column(name="ID")
    @GeneratedValue(generator="resettable-hilo-v5")
    @GenericGenerator(name="resettable-hilo-v5", strategy="com.atlassian.confluence.impl.hibernate.ResettableTableHiLoGeneratorV5")
    public long getId() {
        return super.getId();
    }

    @Transient
    public EditableLabelable getLableable() {
        this.verifyUnion();
        return this.getLabelableNoVerify();
    }

    @Transient
    private EditableLabelable getLabelableNoVerify() {
        if (this.content != null) {
            return this.content;
        }
        if (this.pageTemplate != null) {
            return this.pageTemplate;
        }
        return null;
    }

    private void verifyUnion() {
        ContentEntityObject content = this.getContent();
        PageTemplate pageTemplate = this.getPageTemplate();
        if (content != null && pageTemplate == null || pageTemplate == null && content == null || pageTemplate != null && content == null) {
            return;
        }
        throw new IllegalStateException("At least one of and only one of content and pageTemplate should be not null :\n" + String.valueOf(content) + ",\n" + String.valueOf(pageTemplate));
    }

    protected void setLabelable(EditableLabelable labelable) {
        this.setContent(null);
        this.setPageTemplate(null);
        if (labelable instanceof ContentEntityObject) {
            this.setContent((ContentEntityObject)labelable);
        } else if (labelable instanceof PageTemplate) {
            this.setPageTemplate((PageTemplate)labelable);
        }
        this.updateSummaryValues();
    }

    private void updateSummaryValues() {
        if (this.getLabelableNoVerify() != null) {
            this.labelableId = this.getLableable().getId();
            this.labelableType = LabelableType.getTypeString(this.getLableable().getClass());
        } else {
            this.labelableId = null;
            this.labelableType = null;
        }
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="LABELID", nullable=false)
    @Target(value=Label.class)
    public Label getLabel() {
        return this.label;
    }

    private void setLabel(Label label) {
        this.label = label;
    }

    public ConfluenceUser getOwningUser() {
        return this.owningUser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Labelling labelling = (Labelling)o;
        if (!Objects.equals(this.content, labelling.content)) {
            return false;
        }
        return !(this.label != null ? this.label.getId() != labelling.label.getId() : labelling.label != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 27 * result + (this.content != null ? this.content.hashCode() : 0);
        result = 27 * result + (this.label != null ? this.label.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Labelling[");
        buffer.append("labelable: ").append((String)(this.getLableable() != null ? String.valueOf(this.getLableable()) : "null")).append(", ");
        buffer.append("label: ").append((String)(this.label != null ? "" + this.label.getId() : "null")).append(", ");
        buffer.append("owner: ").append(this.owningUser != null ? this.owningUser.getName() : "null").append("]");
        return buffer.toString();
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PAGETEMPLATEID")
    @Target(value=PageTemplate.class)
    protected PageTemplate getPageTemplate() {
        return this.pageTemplate;
    }

    protected void setPageTemplate(PageTemplate pageTemplate) {
        this.pageTemplate = pageTemplate;
        this.updateSummaryValues();
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CONTENTID")
    @Target(value=ContentEntityObject.class)
    protected ContentEntityObject getContent() {
        return this.content;
    }

    protected void setContent(ContentEntityObject ceo) {
        this.content = ceo;
        this.updateSummaryValues();
    }

    private void setLabelableId(Long id) {
        this.labelableId = id;
    }

    @Column(name="LABELABLEID")
    private Long getLabelableId() {
        return this.labelableId;
    }

    private void setLabelableType(String type) {
        this.labelableType = type;
    }

    @Column(name="LABELABLETYPE")
    private String getLabelableType() {
        return this.labelableType;
    }

    public Labelling copy() {
        return this.copy(this.getLableable());
    }

    public Labelling copy(EditableLabelable labelable) {
        Labelling labelling = new Labelling(this.getLabel(), labelable, this.owningUser);
        this.labelableId = labelable.getId();
        return labelling;
    }
}

