/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.labels;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.SpecialLabelFilter;
import com.atlassian.confluence.labels.VisibleLabelFilter;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.persistence.dao.compatibility.FindUserHelper;
import com.atlassian.user.User;
import com.google.common.base.Predicates;
import io.atlassian.util.concurrent.Lazy;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class PermittedLabelView
implements Labelable {
    private final Labelable original;
    private final ConfluenceUser actingUser;
    private final Predicate<Label> additionalFilter;
    private final Supplier<List<Label>> visibleLabels = Lazy.supplier(this::calculateVisibleLabels);

    PermittedLabelView(Labelable original, ConfluenceUser actingUser, Predicate<Label> additionalFilter) {
        this.original = original;
        this.actingUser = actingUser;
        this.additionalFilter = additionalFilter;
    }

    public PermittedLabelView(Labelable original, User actingUser, boolean hideSpecialLabels) {
        this(original, FindUserHelper.getUser(actingUser), (Predicate<Label>)((Object)(hideSpecialLabels ? new SpecialLabelFilter() : Predicates.alwaysTrue())));
    }

    @Override
    public List<Label> getLabels() {
        return this.visibleLabels.get();
    }

    @Override
    public int getLabelCount() {
        return this.visibleLabels.get().size();
    }

    @Override
    public boolean isFavourite(ConfluenceUser user) {
        return user != null && Label.containsFavouriteLabel((Collection<Label>)this.visibleLabels.get(), user);
    }

    private List<Label> calculateVisibleLabels() {
        return this.original.getLabels().stream().filter(this.createFilter(this.actingUser)).filter(this.additionalFilter).collect(Collectors.toList());
    }

    private Predicate<Label> createFilter(ConfluenceUser user) {
        return user != null ? new VisibleLabelFilter(user.getName()) : new VisibleLabelFilter();
    }

    public Labelable getDelegate() {
        return this.original;
    }
}

