/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.labels;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.labels.SpaceLabelManager;
import com.atlassian.confluence.labels.SpecialLabelFilter;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.core.util.filter.Filter;
import com.atlassian.core.util.filter.FilterChain;
import com.atlassian.core.util.filter.ListFilter;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class SpaceLabelManagerImpl
implements SpaceLabelManager {
    private LabelManager labelManager;
    private SpaceManager spaceManager;

    public SpaceManager getSpaceManager() {
        return this.spaceManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public LabelManager getLabelManager() {
        return this.labelManager;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    @Override
    public Label addLabel(Space space, String labelName) {
        if (space == null) {
            throw new IllegalArgumentException("space must not be null");
        }
        if (StringUtils.isBlank((CharSequence)labelName)) {
            throw new IllegalArgumentException("labelName must not be null or empty, [labelName=" + labelName + "]");
        }
        if (!LabelUtil.isValidLabelName(labelName) || !LabelUtil.isValidLabelLength(labelName)) {
            throw new IllegalArgumentException("labelName is not valid, [labelName=" + labelName + "]");
        }
        Label label = this.buildTeamLabel(labelName);
        this.spaceManager.ensureSpaceDescriptionExists(space);
        int result = this.labelManager.addLabel(space.getDescription(), label);
        LabelUtil.recordLabelInteractionInHistory(label);
        if (result == 0) {
            return null;
        }
        if (result == 1) {
            return this.labelManager.getLabel(label);
        }
        return label;
    }

    @Override
    public List<Label> getTeamLabelsOnSpace(String spaceKey) {
        return this.getLabelManager().getTeamLabelsForSpace(spaceKey);
    }

    @Override
    public List<Label> getAvailableTeamLabels(String spaceKey) {
        List<Label> result = this.getLabelManager().getTeamLabels();
        result.removeAll(this.getTeamLabelsOnSpace(spaceKey));
        return result;
    }

    @Override
    public List<Label> getLabelsOnSpace(Space space) {
        ArrayList<Label> result = new ArrayList<Label>();
        for (Label o : space.getDescription().getLabels()) {
            if (Namespace.isTeam(o)) continue;
            result.add(o);
        }
        FilterChain filterChain = new FilterChain();
        filterChain.addFilter((Filter)new SpecialLabelFilter());
        return new ListFilter((Filter)filterChain).filterList(result);
    }

    @Override
    public List<Label> getSuggestedLabelsForSpace(Space space, User remoteUser) {
        return LabelUtil.getRecentAndPopularLabelsForEntity(space.getDescription(), this.getLabelManager(), 20, remoteUser.getName());
    }

    private Label buildTeamLabel(String labelName) {
        return Optional.ofNullable(LabelParser.parse(labelName, AuthenticatedUserThreadLocal.get())).map(ParsedLabelName::toLabel).filter(Label::isTeamLabel).orElseGet(() -> new Label(labelName, Namespace.TEAM));
    }
}

