/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.labels.actions;

import com.atlassian.confluence.core.Beanable;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.service.ValidationError;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.labels.service.LabelsService;
import com.atlassian.confluence.labels.service.RemoveLabelCommand;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class RemoveSpaceFromFavouriteAjaxAction
extends ConfluenceActionSupport
implements Beanable,
SpaceAware {
    private Map<String, Collection<String>> bean = new HashMap<String, Collection<String>>();
    private long entityId;
    private LabelsService labelsService;
    private RemoveLabelCommand command;
    private RemoveLabelCommand americanCommand;
    private Space space;

    @Override
    public Map<String, Collection<String>> getBean() {
        if (this.bean.isEmpty()) {
            this.getCommand().getRemovedLabels().addAll(this.getAmercianCommand().getRemovedLabels());
            this.bean.put("labels", this.getCommand().getRemovedLabels());
        }
        return this.bean;
    }

    public String execute() {
        if (!this.runCommand(this.getCommand())) {
            return "error";
        }
        if (!this.runCommand(this.getAmercianCommand())) {
            return "error";
        }
        return "success";
    }

    private boolean runCommand(RemoveLabelCommand command) {
        if (!command.isValid()) {
            for (ValidationError error : command.getValidationErrors()) {
                this.addActionError(error.getMessageKey(), error.getArgs());
            }
            return false;
        }
        command.execute();
        return true;
    }

    private RemoveLabelCommand getCommand() {
        if (this.command == null) {
            Label favouriteLabel = new Label("favourite", Namespace.PERSONAL, this.getAuthenticatedUser());
            String labelString = LabelParser.renderWithOwnerPrefix(favouriteLabel);
            this.command = this.labelsService.newRemoveLabelCommand(labelString, this.getAuthenticatedUser(), this.getEntityId());
        }
        return this.command;
    }

    private RemoveLabelCommand getAmercianCommand() {
        if (this.americanCommand == null) {
            Label americanSpelling = new Label("favorite", Namespace.PERSONAL, this.getAuthenticatedUser());
            String labelString = LabelParser.renderWithOwnerPrefix(americanSpelling);
            this.americanCommand = this.labelsService.newRemoveLabelCommand(labelString, this.getAuthenticatedUser(), this.getEntityId());
        }
        return this.americanCommand;
    }

    @Override
    public boolean isPermitted() {
        return this.getCommand().isAuthorized();
    }

    private long getEntityId() {
        if (this.entityId == 0L) {
            this.entityId = this.space.getId();
        }
        return this.entityId;
    }

    public Labelable getEntity() {
        return this.getCommand().getEntity();
    }

    @StrutsParameter
    public void setEntityId(long entityId) {
        this.entityId = entityId;
    }

    @Override
    public void setSpace(Space space) {
        this.space = space;
    }

    @Override
    public boolean isSpaceRequired() {
        return true;
    }

    @Override
    public boolean isViewPermissionRequired() {
        return true;
    }

    @Override
    public Space getSpace() {
        return this.space;
    }

    public void setLabelsService(LabelsService labelsService) {
        this.labelsService = labelsService;
    }
}

