/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.license;

import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.license.LicenseWebFacade;
import com.atlassian.confluence.license.exception.LicenseException;
import com.atlassian.confluence.license.exception.handler.LicenseExceptionHandler;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import io.atlassian.fugue.Either;
import java.util.Optional;
import java.util.concurrent.Callable;

public abstract class LicenseWebFacadeTemplate
implements LicenseWebFacade {
    private LicenseService delegate;

    public LicenseWebFacadeTemplate(LicenseService delegate) {
        this.delegate = delegate;
    }

    @Override
    public Either<String, ConfluenceLicense> retrieveLicense() {
        return this.call(() -> ((LicenseService)this.delegate).retrieve());
    }

    @Override
    public Either<String, Optional<ProductLicense>> retrieveForProduct(Product product) {
        return this.call(() -> this.delegate.retrieveForProduct(product));
    }

    @Override
    public Either<String, ConfluenceLicense> validateLicense(String licenseString) throws LicenseException {
        return this.call(() -> this.delegate.validate(licenseString));
    }

    @Override
    public Either<String, ProductLicense> validateLicenseForPlugin(String licenseString, Product product) throws LicenseException {
        return this.call(() -> this.delegate.validate(licenseString, product));
    }

    @Override
    public Either<String, ConfluenceLicense> installLicense(String licenseString) throws LicenseException {
        return this.call(() -> this.delegate.install(licenseString));
    }

    @Override
    public Either<String, Boolean> licensedForDataCenter() {
        return this.call(() -> ((LicenseService)this.delegate).isLicensedForDataCenter());
    }

    private <R> Either<String, R> call(Callable<R> receiver) {
        try {
            return Either.right(receiver.call());
        }
        catch (Exception exception) {
            return Either.left((Object)this.createExceptionHandler().handle(exception));
        }
    }

    protected abstract LicenseExceptionHandler<Exception> createExceptionHandler();
}

