/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.like;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.like.LikeEntity;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class Like {
    private final long contentId;
    private final ConfluenceUser user;
    private final Date createdDate;

    @VisibleForTesting
    public Like(long contentId, ConfluenceUser user, Date createdDate) {
        if (contentId <= 0L) {
            throw new IllegalArgumentException("contentId must be greater than 0");
        }
        this.contentId = contentId;
        this.user = Objects.requireNonNull(user);
        this.createdDate = Objects.requireNonNull(createdDate);
    }

    public Like(LikeEntity likeEntity) {
        this.contentId = likeEntity.getContent().getId();
        this.user = likeEntity.getUser();
        this.createdDate = likeEntity.getCreationDate();
    }

    public long getContentId() {
        return this.contentId;
    }

    public ConfluenceUser getUser() {
        return this.user;
    }

    public String getUsername() {
        return this.user == null ? null : this.user.getName();
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Like)) {
            return false;
        }
        Like that = (Like)obj;
        return new EqualsBuilder().append(this.contentId, that.contentId).append((Object)this.user, (Object)that.user).append((Object)this.createdDate, (Object)that.createdDate).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.contentId).append((Object)this.user).append((Object)this.createdDate).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(this.contentId).append((Object)this.user).append((Object)this.createdDate).toString();
    }
}

