/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.like;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.google.common.base.Preconditions;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.Objects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Target;

@Entity
@Table(name="LIKES", indexes={@Index(name="like_cid_idx", columnList="CONTENTID"), @Index(name="like_username_idx", columnList="USERNAME"), @Index(name="like_cdate_idx", columnList="CREATIONDATE")})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Proxy(lazy=false)
public class LikeEntity {
    @Id
    @Column(name="ID", updatable=false)
    @GenericGenerator(name="resettable-hilo-v5", strategy="com.atlassian.confluence.impl.hibernate.ResettableTableHiLoGeneratorV5")
    @GeneratedValue(generator="resettable-hilo-v5")
    private long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(name="CONTENTID", nullable=false)
    private ContentEntityObject content;
    @ManyToOne(fetch=FetchType.LAZY)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(name="USERNAME", nullable=false, foreignKey=@ForeignKey(name="FK_LIKES_USERNAME"))
    @Target(value=ConfluenceUserImpl.class)
    private ConfluenceUser user;
    @Column(name="CREATIONDATE", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date creationDate;

    public LikeEntity() {
    }

    public LikeEntity(ContentEntityObject content, ConfluenceUser user, Date creationDate) {
        Preconditions.checkNotNull((Object)content, (Object)"Content to like must not be null");
        if (user == null) {
            throw new IllegalArgumentException("user must not be null");
        }
        if (creationDate == null) {
            throw new IllegalArgumentException("creationDate must not be null");
        }
        this.content = content;
        this.user = user;
        this.creationDate = creationDate;
    }

    public ContentEntityObject getContent() {
        return this.content;
    }

    public ConfluenceUser getUser() {
        return this.user;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public long getId() {
        return this.id;
    }

    public void setContent(ContentEntityObject content) {
        this.content = content;
    }

    public void setUser(ConfluenceUser user) {
        this.user = user;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LikeEntity)) {
            return false;
        }
        LikeEntity that = (LikeEntity)obj;
        return Objects.equals(this.user, that.user) && Objects.equals(this.content, that.content);
    }

    public int hashCode() {
        return Objects.hash(this.user, this.content);
    }
}

