/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.links;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.impl.hibernate.Hibernate;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Target;

@MappedSuperclass
@Access(value=AccessType.PROPERTY)
public abstract class AbstractLink
extends ConfluenceEntityObject {
    private ContentEntityObject sourceContent;
    private String linkTitle;

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CONTENTID", nullable=false)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    public ContentEntityObject getSourceContent() {
        return this.sourceContent;
    }

    public void setSourceContent(ContentEntityObject sourceContent) {
        this.sourceContent = sourceContent;
    }

    @Override
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CREATOR", foreignKey=@ForeignKey(name="FK_LINKS_CREATOR"))
    @Target(value=ConfluenceUserImpl.class)
    public ConfluenceUser getCreator() {
        return super.getCreator();
    }

    @Override
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="LASTMODIFIER", foreignKey=@ForeignKey(name="FK_LINKS_LASTMODIFIER"))
    @Target(value=ConfluenceUserImpl.class)
    public ConfluenceUser getLastModifier() {
        return super.getLastModifier();
    }

    @Transient
    public String getLinkTitle() {
        return this.linkTitle;
    }

    public void setLinkTitle(String title) {
        if (title == null || !StringUtils.isNotEmpty((CharSequence)title.trim())) {
            this.linkTitle = null;
        }
        this.linkTitle = title;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        AbstractLink that = (AbstractLink)o;
        return Objects.equals(this.getSourceContent(), that.getSourceContent());
    }

    public int hashCode() {
        int result = 17;
        result = 29 * result + (this.getSourceContent() != null ? this.getSourceContent().hashCode() : 0);
        return result;
    }
}

