/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.links;

import com.atlassian.confluence.links.linktypes.IncludePageMacroLink;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.RegexUtils;
import com.atlassian.confluence.util.UrlUtils;
import com.atlassian.renderer.v2.WikiMarkupParser;
import com.atlassian.renderer.v2.components.MacroTag;
import com.atlassian.renderer.v2.components.WikiContentHandler;
import com.atlassian.renderer.v2.macro.Macro;
import com.atlassian.renderer.v2.macro.MacroManager;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class LinkParserHelper
implements WikiContentHandler {
    static final String URL_PATTERN;
    static final String PURE_URL_PATTERN;
    private final List<String> links = new ArrayList<String>();
    private final String pageContent;
    private final MacroManager macroManager;
    private final SettingsManager settingsManager;

    public LinkParserHelper(String pageContent, MacroManager macroManager, SettingsManager settingsManager) {
        this.macroManager = macroManager;
        this.pageContent = pageContent;
        this.settingsManager = settingsManager;
    }

    public void handleMacro(StringBuffer buffer, MacroTag macroTag, String body) {
        assert (macroTag.command != null);
        Macro macro = this.macroManager.getEnabledMacro(macroTag.command.toLowerCase());
        if (macro != null && macro.hasBody() && (macro.getBodyRenderMode() == null || macro.getBodyRenderMode().renderLinks())) {
            this.extractLinks(body);
        }
    }

    public void handleText(StringBuffer buffer, String s) {
        this.links.addAll(RegexUtils.getMatches((String)"(\\[)([\\p{L}&[^\\[\\]\\p{Space}]][\\p{L}&[^\\[\\]]]*)\\]", (String)s));
        this.links.addAll(RegexUtils.getMatches((String)URL_PATTERN, (String)s));
        if (this.settingsManager.getGlobalSettings().isAllowCamelCase()) {
            this.links.addAll(RegexUtils.getMatches((String)"([^a-zA-Z0-9!/\\[]|^)([A-Z])([a-z]+([A-Z][a-zA-Z0-9]+)+)(([^a-zA-Z0-9!\\]])|\r?\n|$)", (String)s));
        }
        this.links.addAll(RegexUtils.getMatches((Pattern)IncludePageMacroLink.pattern, (String)s));
    }

    public List<String> extractLinks() {
        this.extractLinks(this.pageContent);
        return this.links;
    }

    private void extractLinks(String content) {
        WikiMarkupParser parser = new WikiMarkupParser(this.macroManager, (WikiContentHandler)this);
        parser.parse(content);
    }

    static {
        PURE_URL_PATTERN = UrlUtils.URL_PATTERN;
        URL_PATTERN = "([^\"\\[\\|'!]|^)" + PURE_URL_PATTERN;
    }
}

