/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.links;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.links.AbstractLink;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.renderer.util.UrlUtil;
import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.NamedNativeQueries;
import jakarta.persistence.NamedNativeQuery;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.Objects;
import org.hibernate.Hibernate;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Proxy;

@Entity
@Table(name="LINKS", indexes={@Index(name="l_destpgtitle_idx", columnList="DESTPAGETITLE"), @Index(name="l_ldestpgtitle_idx", columnList="LOWERDESTPAGETITLE"), @Index(name="l_destspacekey_idx", columnList="DESTSPACEKEY"), @Index(name="l_ldestspacekey_idx", columnList="LOWERDESTSPACEKEY"), @Index(name="l_contentid_idx", columnList="CONTENTID"), @Index(name="links_creator_idx", columnList="CREATOR"), @Index(name="links_lastmodifier_idx", columnList="LASTMODIFIER")})
@NamedQueries(value={@NamedQuery(name="confluence.links_findOutgoingLinkBySpaceKeyAndPageTitle", query="from OutgoingLink link where link.lowerDestinationSpaceKey = :spaceKey and link.lowerDestinationPageTitle = :pageTitle"), @NamedQuery(name="confluence.links_countNumberOfPageHaveIncomingLinkInHierarchy", query="select CAST(count(distinct link.lowerDestinationPageTitle) AS integer) from OutgoingLink link, Page c where link.lowerDestinationSpaceKey = c.space.lowerKey and link.lowerDestinationPageTitle = c.lowerTitle and link.sourceContent.contentStatus = 'current' and link.sourceContent.id not in (select page.id from Page page left join page.ancestors as ancestor where page.originalVersion is null and page.contentStatus = 'current' and (ancestor.id = :rootPageId or page.id = :rootPageId)) and link.lowerDestinationPageTitle in (select page.lowerTitle from Page page left join page.ancestors as ancestor where page.originalVersion is null and page.contentStatus = 'current' and (ancestor.id = :rootPageId or page.id = :rootPageId)) and link.lowerDestinationSpaceKey = :searchSpaceKey"), @NamedQuery(name="confluence.links_findOutgoingLinksWithValidSpaceKey", query="from OutgoingLink link where link.lowerDestinationSpaceKey not in ('mailto', 'nntp', 'news', 'http', 'https', 'ftp', 'ftps', 'mailto') and link.lowerDestinationPageTitle not like '%@%'"), @NamedQuery(name="confluence.links_findOutgoingLinksWithSpaceKey", query="from OutgoingLink link where link.lowerDestinationSpaceKey = :spaceKey")})
@NamedNativeQueries(value={@NamedNativeQuery(name="confluence.links_findOutgoingLinkBySpaceAndSubTreePageTitles", query="SELECT destpage.CONTENTID as destPageId, link.LOWERDESTSPACEKEY as lowerDestSpaceKey, link.LOWERDESTPAGETITLE as lowerDestPageTitle, sourcepage.CONTENTID as sourcePageId FROM LINKS link INNER JOIN CONTENT destpage ON link.LOWERDESTPAGETITLE = destpage.LOWERTITLE INNER JOIN CONTENT sourcepage ON link.CONTENTID = sourcepage.CONTENTID WHERE link.LOWERDESTSPACEKEY = :lowerDestSpaceKey     AND link.LOWERDESTPAGETITLE IN (:parentPageTreeTitles)     AND destpage.SPACEID = :destSpaceId     AND destpage.CONTENTTYPE = 'PAGE'     AND sourcepage.CONTENT_STATUS = 'current' ")})
@Access(value=AccessType.PROPERTY)
@Proxy(lazy=false)
public class OutgoingLink
extends AbstractLink
implements Comparable<OutgoingLink> {
    private String destinationPageTitle;
    private String lowerDestinationPageTitle;
    private String destinationSpaceKey;
    private String lowerDestinationSpaceKey;

    public OutgoingLink() {
    }

    public OutgoingLink(ContentEntityObject sourceContent, String destinationSpaceKey, String destinationPageTitle) {
        this.setSourceContent(sourceContent);
        this.setDestinationPageTitle(destinationPageTitle);
        this.setDestinationSpaceKey(destinationSpaceKey);
    }

    @Id
    @Column(name="LINKID")
    @GeneratedValue(generator="resettable-hilo-v5")
    @GenericGenerator(name="resettable-hilo-v5", strategy="com.atlassian.confluence.impl.hibernate.ResettableTableHiLoGeneratorV5")
    public long getId() {
        return super.getId();
    }

    @Column(name="DESTPAGETITLE", length=255)
    public String getDestinationPageTitle() {
        return this.destinationPageTitle;
    }

    public void setDestinationPageTitle(String destinationPageTitle) {
        if (destinationPageTitle != null && destinationPageTitle.length() > 255) {
            destinationPageTitle = destinationPageTitle.substring(0, 255);
        }
        this.destinationPageTitle = destinationPageTitle;
        this.lowerDestinationPageTitle = GeneralUtil.specialToLowerCase(destinationPageTitle);
    }

    @Column(name="LOWERDESTPAGETITLE", length=255)
    public String getLowerDestinationPageTitle() {
        return this.lowerDestinationPageTitle;
    }

    private void setLowerDestinationPageTitle(String lowerDestinationPageTitle) {
        this.lowerDestinationPageTitle = lowerDestinationPageTitle;
    }

    @Column(name="DESTSPACEKEY", length=255, nullable=false)
    public String getDestinationSpaceKey() {
        return this.destinationSpaceKey;
    }

    public void setDestinationSpaceKey(String destinationSpaceKey) {
        if (destinationSpaceKey != null && destinationSpaceKey.length() > 255) {
            destinationSpaceKey = destinationSpaceKey.substring(0, 255);
        }
        this.destinationSpaceKey = destinationSpaceKey;
        this.lowerDestinationSpaceKey = GeneralUtil.specialToLowerCase(destinationSpaceKey);
    }

    @Column(name="LOWERDESTSPACEKEY", length=255)
    public String getLowerDestinationSpaceKey() {
        return this.lowerDestinationSpaceKey;
    }

    private void setLowerDestinationSpaceKey(String lowerDestinationSpaceKey) {
        this.lowerDestinationSpaceKey = lowerDestinationSpaceKey;
    }

    @Transient
    public boolean isUrlLink() {
        for (String protocol : UrlUtil.URL_PROTOCOLS) {
            int index = protocol.indexOf(58);
            if (index != -1) {
                protocol = protocol.substring(0, index);
            }
            if (!protocol.equalsIgnoreCase(this.getDestinationSpaceKey())) continue;
            return true;
        }
        return false;
    }

    @Transient
    public String getUrlLink() {
        return this.getDestinationSpaceKey() + ":" + this.getDestinationPageTitle();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OutgoingLink that = (OutgoingLink)o;
        return Objects.equals(this.getDestinationPageTitle(), that.getDestinationPageTitle()) && Objects.equals(this.getDestinationSpaceKey(), that.getDestinationSpaceKey());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.getDestinationSpaceKey() != null ? this.getDestinationSpaceKey().hashCode() : 0);
        result = 29 * result + (this.getDestinationPageTitle() != null ? this.getDestinationPageTitle().hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(OutgoingLink other) {
        int comparison = this.getSourceContent().compareTo(other.getSourceContent());
        if (comparison == 0 && (comparison = this.getDestinationSpaceKey().compareTo(other.getDestinationSpaceKey())) == 0) {
            comparison = this.getDestinationPageTitle().compareTo(other.getDestinationPageTitle());
        }
        return comparison;
    }

    public String toString() {
        return this.getUrlLink();
    }

    public boolean isFrom(AbstractPage page) {
        ContentEntityObject source = this.getSourceContent();
        return page != null && source != null && source instanceof AbstractPage && source.getId() == page.getId();
    }
}

