/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.links;

import com.atlassian.confluence.core.AnnotatedEntityObject;
import com.atlassian.confluence.impl.hibernate.Hibernate;
import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Proxy;

@Entity
@Table(name="TITLE_CONTENT_MAPPING", indexes={@Index(name="idx_title", columnList="TITLE"), @Index(name="idx_contentid", columnList="CONTENTID")})
@NamedQueries(value={@NamedQuery(name="confluence.titleContentMapping_findContentIdByTitle", query="from TitleContentMapping titleContentMapping where titleContentMapping.title = :title"), @NamedQuery(name="confluence.titleContentMapping_deleteByTitle", query="delete from TitleContentMapping titleContentMapping where titleContentMapping.title = :title and titleContentMapping.contentId = :contentId"), @NamedQuery(name="confluence.titleContentMapping_findFirstContentId", query="select tcm from TitleContentMapping tcm where tcm.contentId = (select tcmSub.contentId from TitleContentMapping tcmSub where tcmSub.id = (select min(tcmInner.id) from TitleContentMapping tcmInner))")})
@Access(value=AccessType.PROPERTY)
@Proxy(lazy=false)
public class TitleContentMapping
extends AnnotatedEntityObject {
    private long id;
    private String title;
    private Long contentId;

    public TitleContentMapping() {
    }

    public TitleContentMapping(String title, Long contentid) {
        this.title = title;
        this.contentId = contentid;
    }

    @Id
    @Column(name="ID")
    @GeneratedValue(generator="resettable-hilo-v5")
    @GenericGenerator(name="resettable-hilo-v5", strategy="com.atlassian.confluence.impl.hibernate.ResettableTableHiLoGeneratorV5")
    public long getId() {
        return this.id;
    }

    @Column(name="TITLE", length=255)
    public String getTitle() {
        return this.title;
    }

    @Column(name="CONTENTID")
    public Long getContentId() {
        return this.contentId;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setContentId(Long contentId) {
        this.contentId = contentId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TitleContentMapping that = (TitleContentMapping)o;
        if (this.getContentId() != null ? !this.getContentId().equals(that.getContentId()) : that.getContentId() != null) {
            return false;
        }
        return !(this.getTitle() != null ? !this.getTitle().equals(that.getTitle()) : that.getTitle() != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.contentId != null ? this.contentId.hashCode() : 0);
        return result;
    }
}

