/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.links.linktypes;

import com.atlassian.confluence.links.linktypes.AbstractPageLink;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.renderer.links.GenericLinkParser;
import com.atlassian.struts.xsrf.XsrfTokenGenerator;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;

public class PageCreateLink
extends AbstractPageLink {
    public static final String CREATE_ICON = "create";

    public PageCreateLink(GenericLinkParser parser, PageContext context, XsrfTokenGenerator xsrfTokenGenerator) throws ParseException {
        super(parser, context);
        this.iconName = CREATE_ICON;
        if (StringUtils.isNotEmpty((CharSequence)context.getSpaceKey()) && this.spaceKey.equals(context.getSpaceKey())) {
            this.setI18nTitle("renderer.create.page", Collections.singletonList(this.entityName));
        } else {
            this.setI18nTitle("renderer.create.page.in.space", Arrays.asList(this.spaceKey, this.entityName));
        }
        this.makeCreatePage(context, xsrfTokenGenerator);
    }

    public String getLinkAttributes() {
        return " class=\"createlink\"";
    }

    private void makeCreatePage(PageContext context, XsrfTokenGenerator xsrfTokenGenerator) {
        this.url = "/pages/createpage.action?spaceKey=" + this.spaceKey + this.makeTitle(this.entityName);
        if (context.getEntity() != null && context.getEntity() instanceof Page && this.spaceKey.equalsIgnoreCase(context.getSpaceKey())) {
            this.url = this.url + "&linkCreation=true&fromPageId=" + context.getEntity().getId();
        }
        if (ServletContextThreadLocal.getRequest() != null) {
            this.url = this.url + "&atl_token=" + xsrfTokenGenerator.getToken(ServletContextThreadLocal.getRequest(), true);
        }
    }

    private String makeTitle(String entityTitle) {
        if (GeneralUtil.isAllAscii(entityTitle)) {
            return "&title=" + HtmlUtil.urlEncode(entityTitle);
        }
        return "&encodedTitle=" + GeneralUtil.base64Encode(entityTitle);
    }

    @Override
    protected boolean isOnSamePage(PageContext pageContext) {
        return false;
    }
}

