/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.links.persistence.dao.hibernate;

import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.core.persistence.hibernate.ConfluenceHibernateObjectDao;
import com.atlassian.confluence.impl.content.render.prefetch.hibernate.HibernatePrefetchHelper;
import com.atlassian.confluence.internal.links.persistence.LinkDaoInternal;
import com.atlassian.confluence.links.OutgoingLink;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.GeneralUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import jakarta.persistence.Tuple;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.dao.support.DataAccessUtils;

public class HibernateLinkDao
extends ConfluenceHibernateObjectDao<OutgoingLink>
implements LinkDaoInternal {
    private static final int HIBERNATE_LINK_QUERY_BATCH_SIZE = Integer.getInteger("confluence.hibernate.link.query-batch-size", 1000);

    @Override
    public Class<OutgoingLink> getPersistentClass() {
        return OutgoingLink.class;
    }

    @Override
    public <T> Stream<T> countIncomingLinksForContents(SpaceContentEntityObject rootPage, SpaceContentEntityObject parentPage, Function<Object, T> mapper) {
        Objects.requireNonNull(rootPage);
        Objects.requireNonNull(parentPage);
        Preconditions.checkArgument((boolean)rootPage.getSpaceKey().equals(parentPage.getSpaceKey()));
        String lowerSpaceKey = rootPage.getSpace().getLowerKey();
        long spaceId = rootPage.getSpace().getId();
        Session session = this.getSessionFactory().getCurrentSession();
        HashSet<Long> rootPageTreeIds = new HashSet<Long>(session.createNativeQuery("SELECT descendentid FROM CONFANCESTORS ancestors WHERE ancestors.ANCESTORID = :ancestorId").setCacheable(true).addScalar("descendentid", (Type)StandardBasicTypes.LONG).setParameter("ancestorId", (Object)rootPage.getId()).list());
        rootPageTreeIds.add(rootPage.getId());
        List<String> parentPageTreeTitles = session.getNamedQuery("confluence.page_getChildrenTitles").setParameter("parentId", (Object)parentPage.getId()).setParameter("status", (Object)ContentStatus.CURRENT.getValue()).list();
        parentPageTreeTitles.add(parentPage.getTitle());
        parentPageTreeTitles = parentPageTreeTitles.stream().map(String::toLowerCase).toList();
        Collection dbResults = HibernatePrefetchHelper.partitionedQuery(parentPageTreeTitles, HIBERNATE_LINK_QUERY_BATCH_SIZE, titles -> session.createNamedQuery("confluence.links_findOutgoingLinkBySpaceAndSubTreePageTitles", Tuple.class).setParameter("lowerDestSpaceKey", (Object)lowerSpaceKey).setParameter("destSpaceId", (Object)spaceId).setParameter("parentPageTreeTitles", titles).getResultList());
        List mappedResults = dbResults.stream().filter(tuple -> !rootPageTreeIds.contains(((Number)tuple.get("sourcePageId")).longValue())).collect(Collectors.groupingBy(tuple -> Arrays.asList(((Number)tuple.get("destPageId")).longValue(), tuple.get("lowerDestSpaceKey"), tuple.get("lowerDestPageTitle")), Collectors.counting())).entrySet().stream().map(entry -> {
            List key = (List)entry.getKey();
            Long count = (Long)entry.getValue();
            return new Object[]{key.get(0), key.get(1), key.get(2), count.intValue()};
        }).collect(Collectors.toList());
        return Objects.requireNonNull(mappedResults.stream()).map(mapper);
    }

    @Override
    public int countPagesWithIncomingLinks(SpaceContentEntityObject rootPage) {
        Objects.requireNonNull(rootPage);
        String lowerSpaceKey = rootPage.getSpace().getLowerKey();
        return DataAccessUtils.intResult((Collection)this.hibernate().execute(session -> {
            Query queryObject = session.getNamedQuery("confluence.links_countNumberOfPageHaveIncomingLinkInHierarchy").setParameter("searchSpaceKey", (Object)lowerSpaceKey).setParameter("rootPageId", (Object)rootPage.getId());
            return queryObject.list();
        }));
    }

    @Override
    public List<OutgoingLink> getLinksTo(ContentEntityObject theContent) {
        if (theContent == null || theContent.isDraft()) {
            return Collections.emptyList();
        }
        ContentEntityObject content = (ContentEntityObject)theContent.getLatestVersion();
        return this.hibernate().execute(session -> {
            Space space;
            Query queryObject = session.createNamedQuery("confluence.links_findOutgoingLinkBySpaceKeyAndPageTitle", OutgoingLink.class);
            HibernateLinkDao.applyTransactionTimeout(queryObject, this.getSessionFactory());
            String spaceKey = null;
            String pageTitle = this.extractTitle(content);
            if (content instanceof SpaceContentEntityObject && (space = ((SpaceContentEntityObject)content).getSpace()) != null) {
                spaceKey = space.getKey();
            }
            if (StringUtils.isEmpty(spaceKey)) {
                return Collections.emptyList();
            }
            return queryObject.setParameter("spaceKey", (Object)GeneralUtil.specialToLowerCase(spaceKey)).setParameter("pageTitle", (Object)GeneralUtil.specialToLowerCase(pageTitle)).list();
        });
    }

    @Override
    public List<ContentEntityObject> getReferringContent(ContentEntityObject content) {
        if (content == null || content.isDraft()) {
            return Collections.emptyList();
        }
        String extractedSpaceKey = this.extractSpaceKey(content);
        if (StringUtils.isBlank((CharSequence)extractedSpaceKey)) {
            extractedSpaceKey = this.extractSpaceKey((ContentEntityObject)content.getLatestVersion());
        }
        if (StringUtils.isEmpty((CharSequence)extractedSpaceKey)) {
            return Collections.emptyList();
        }
        return this.getReferringContent(extractedSpaceKey, Collections.singletonList(content));
    }

    @Override
    public List<ContentEntityObject> getReferringContent(String spaceKey, List<ContentEntityObject> contents) {
        if (StringUtils.isEmpty((CharSequence)spaceKey)) {
            return Collections.emptyList();
        }
        List titles = contents.stream().map(content -> GeneralUtil.specialToLowerCase(this.extractTitle((ContentEntityObject)content))).filter(Objects::nonNull).collect(Collectors.toList());
        Iterable titleBatch = Iterables.partition(titles, (int)HIBERNATE_LINK_QUERY_BATCH_SIZE);
        HashSet set = new HashSet();
        for (List batch : titleBatch) {
            List result = Objects.requireNonNull(this.hibernate().execute(session -> {
                session.flush();
                Query query = session.createQuery("select c from ContentEntityObject c join c.outgoingLinks l where l.destinationSpaceKey = :spacekey and l.lowerDestinationPageTitle in (:titles)", ContentEntityObject.class);
                query.setParameter("spacekey", (Object)spaceKey);
                query.setParameterList("titles", batch.toArray());
                HibernateLinkDao.applyTransactionTimeout(query, this.getSessionFactory());
                return query.list();
            }));
            set.addAll(result);
        }
        return set.stream().collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    private String extractSpaceKey(ContentEntityObject content) {
        if (content instanceof SpaceContentEntityObject) {
            return ((SpaceContentEntityObject)content).getSpaceKey();
        }
        return "";
    }

    private String extractTitle(ContentEntityObject content) {
        return content instanceof BlogPost ? ((BlogPost)content).getLinkPart() : content.getTitle();
    }

    @Override
    public void removeCorruptOutgoingLinks() {
        this.hibernate().execute(session -> {
            List corruptLinks = session.createQuery("from OutgoingLink l where l.sourceContent.space = null", OutgoingLink.class).list();
            for (OutgoingLink link : corruptLinks) {
                link.getSourceContent().removeOutgoingLink(link);
                session.delete((Object)link);
            }
            return null;
        });
    }

    @Override
    public void remove(OutgoingLink link) {
        super.remove(link);
    }
}

