/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.links.persistence.dao.hibernate;

import com.atlassian.confluence.core.persistence.hibernate.HibernateObjectDao;
import com.atlassian.confluence.links.TitleContentMapping;
import com.atlassian.confluence.links.persistence.dao.TitleContentMappingDao;
import java.util.List;
import org.hibernate.query.Query;

public class HibernateTitleContentMappingDao
extends HibernateObjectDao<TitleContentMapping>
implements TitleContentMappingDao {
    @Override
    public Class<TitleContentMapping> getPersistentClass() {
        return TitleContentMapping.class;
    }

    @Override
    public List<TitleContentMapping> getTitlesForOldestContentIdGroup() {
        return this.hibernate().execute(session -> {
            Query query = session.getNamedQuery("confluence.titleContentMapping_findFirstContentId");
            HibernateTitleContentMappingDao.applyTransactionTimeout(query, this.getSessionFactory());
            return query.list();
        });
    }

    @Override
    public Long getContentIdByTitle(String title) {
        List result = this.hibernate().execute(session -> {
            Query query = session.getNamedQuery("confluence.titleContentMapping_findContentIdByTitle");
            query.setParameter("title", (Object)title);
            HibernateTitleContentMappingDao.applyTransactionTimeout(query, this.getSessionFactory());
            return query.list();
        });
        return result == null || result.isEmpty() ? null : ((TitleContentMapping)result.get(0)).getContentId();
    }

    @Override
    public void deleteByTitle(String title, long contentId) {
        this.hibernate().execute(session -> {
            Query query = session.getNamedQuery("confluence.titleContentMapping_deleteByTitle");
            query.setParameter("title", (Object)title);
            query.setParameter("contentId", (Object)contentId);
            HibernateTitleContentMappingDao.applyTransactionTimeout(query, this.getSessionFactory());
            query.executeUpdate();
            return null;
        });
    }

    @Override
    public void create(TitleContentMapping titleContentMapping) {
        this.hibernate().saveOrUpdate(titleContentMapping);
    }
}

