/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.macro.count;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiFunction;

public enum MacroCreateCustomMetricsDefinitions {
    TASKS_REPORT_MACRO("tasks-report-macro", (entity, context) -> {
        if (entity == null) {
            return Collections.emptyMap();
        }
        Object macroDefinition = context.getProperty("macroDefinition");
        if (macroDefinition == null) {
            return Collections.emptyMap();
        }
        String pages = ((MacroDefinition)macroDefinition).getParameter("pages");
        String currentPageIncludedMetricKey = "tasks-report-macro.isCurrentPageIncluded";
        String newSavedPageMetricKey = "tasks-report-macro.isNewSavedPage";
        Long entityId = entity.getOriginalVersionId();
        long newSavedPage = 0L;
        long currentPageIncluded = 0L;
        if (entityId == null) {
            entityId = entity.getId();
            newSavedPage = 1L;
        }
        if (pages != null && Arrays.asList(pages.split(",")).contains(String.valueOf(entityId))) {
            currentPageIncluded = 1L;
        }
        return Map.of("tasks-report-macro.isCurrentPageIncluded", currentPageIncluded, "tasks-report-macro.isNewSavedPage", newSavedPage);
    }),
    DEFAULT("default", (entity, conversionContext) -> Collections.emptyMap());

    private final String macroType;
    private final transient BiFunction<ContentEntityObject, ConversionContext, Map<String, Long>> customMetricsBuilder;

    private MacroCreateCustomMetricsDefinitions(String macroType, BiFunction<ContentEntityObject, ConversionContext, Map<String, Long>> customMetricsBuilder) {
        this.macroType = macroType;
        this.customMetricsBuilder = customMetricsBuilder;
    }

    public static MacroCreateCustomMetricsDefinitions getByMacroType(String macroType) {
        return Arrays.stream(MacroCreateCustomMetricsDefinitions.values()).filter(v -> v.getMacroType().equals(macroType)).findFirst().orElse(DEFAULT);
    }

    public String getMacroType() {
        return this.macroType;
    }

    public BiFunction<ContentEntityObject, ConversionContext, Map<String, Long>> getCustomMetricsBuilder() {
        return this.customMetricsBuilder;
    }
}

