/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.dmz.BandanaManagerInternal;
import com.atlassian.confluence.event.events.admin.MailServerCreateEvent;
import com.atlassian.confluence.event.events.admin.MailServerDeleteEvent;
import com.atlassian.confluence.event.events.admin.MailServerEditEvent;
import com.atlassian.confluence.event.events.analytics.MailServerAnalytics;
import com.atlassian.confluence.mail.Authorization;
import com.atlassian.confluence.mail.ConfluenceSmtpMailServer;
import com.atlassian.confluence.mail.MailServerSerializationService;
import com.atlassian.confluence.mail.PasswordFilteringLogPrintStream;
import com.atlassian.confluence.mail.auth.ConfluenceAuthenticationContextFactory;
import com.atlassian.confluence.mail.auth.DefaultConfluenceMailOAuth2Credentials;
import com.atlassian.confluence.oauth2.OAuth2Exception;
import com.atlassian.confluence.oauth2.OAuth2Service;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.mail.server.ImapMailServer;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.PopMailServer;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.mail.server.auth.AuthenticationContext;
import com.atlassian.mail.server.auth.Credentials;
import com.atlassian.mail.server.managers.AbstractMailServerManager;
import com.atlassian.oauth2.client.api.storage.token.ClientTokenEntity;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.api.SecretServiceState;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceMailServerManager
extends AbstractMailServerManager {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceMailServerManager.class);
    private static final org.apache.log4j.Logger loggerSession = org.apache.log4j.Logger.getLogger((String)"com.atlassian.confluence.mail.session");
    public static final String TLS_HOSTNAME_VERIFICATION_DISABLED = "confluence.mailserver.tls.hostname.verification.disabled";
    public static final String MAIL_SERVER_PASSWORD_SECRET_PREFIX = "mail.server.password.";
    private BandanaManagerInternal bandanaManager;
    public static final String INVALID_TOKEN_NAME = "invalid";
    private EventPublisher eventPublisher;
    private SecretService secretService;
    private ConfluenceAuthenticationContextFactory authCtxFactory;
    private OAuth2Service oAuth2Service;
    private final boolean isTLSHostNameVerificationEnabled = !Boolean.getBoolean("confluence.mailserver.tls.hostname.verification.disabled");
    private MailServerSerializationService mailServerSerializationService;

    public void setMailServerSerializationService(MailServerSerializationService mailServerSerializationService) {
        this.mailServerSerializationService = mailServerSerializationService;
    }

    public MailServer getMailServer(Long id) {
        return this.getMailServers().get(id);
    }

    public MailServer getMailServer(String name) {
        return this.getMailServers().values().stream().filter(server -> name.equals(server.getName())).findAny().orElse(null);
    }

    public List<String> getServerNames() {
        return this.getMailServers().values().stream().map(MailServer::getName).toList();
    }

    public List<SMTPMailServer> getSmtpMailServers() {
        return this.getMailServers(SMTPMailServer.class);
    }

    public List<PopMailServer> getPopMailServers() {
        return this.getMailServers(PopMailServer.class);
    }

    public List<ImapMailServer> getImapMailServers() {
        return this.getMailServers(ImapMailServer.class);
    }

    public SMTPMailServer getDefaultSMTPMailServer() {
        return (SMTPMailServer)Iterables.getFirst(this.getSmtpMailServers(), null);
    }

    public PopMailServer getDefaultPopMailServer() {
        return (PopMailServer)Iterables.getFirst(this.getPopMailServers(), null);
    }

    public Long create(MailServer mailServer) {
        if (mailServer instanceof SMTPMailServer || mailServer instanceof PopMailServer || mailServer instanceof ImapMailServer) {
            Map<Long, MailServer> mailServers = this.getMailServers();
            Long id = System.currentTimeMillis();
            mailServer.setId(id);
            this.configureMailServer(mailServer);
            mailServers.put(id, mailServer);
            this.saveServerMap(mailServers);
            this.publishCreateEvent(mailServer);
            return id;
        }
        String message = "Attempt to create unsupported mail server type: " + mailServer.getClass().getName();
        logger.warn(message);
        throw new UnsupportedOperationException(message);
    }

    public void update(MailServer mailServer) {
        Map<Long, MailServer> serverMap = this.getMailServers();
        serverMap.put(mailServer.getId(), mailServer);
        this.configureMailServer(mailServer);
        this.saveServerMap(serverMap);
        this.publishEditEvent(mailServer);
    }

    public void delete(Long mailServerId) {
        Map<Long, MailServer> serverMap = this.getMailServers();
        MailServer mailServer = serverMap.remove(mailServerId);
        try {
            if (SecretService.getState() == SecretServiceState.ENABLED) {
                this.secretService.delete(ConfluenceMailServerManager.getMailServerSecretId(mailServer));
            }
            this.saveServerMap(serverMap);
            this.publishDeleteEvent(mailServer);
        }
        catch (SecretServiceException sse) {
            logger.error("Failed to delete password for mail server [{}] from secret service - {}", (Object)this.getServerDescription(mailServer), (Object)sse.getCause());
        }
    }

    public void deleteAll() {
        this.getMailServers().values().forEach(this::publishDeleteEvent);
        this.saveServerMap(null);
    }

    private void publishDeleteEvent(MailServer mailServer) {
        logger.info("Deleted {}", (Object)this.getServerDescription(mailServer));
        this.eventPublisher.publish((Object)new MailServerDeleteEvent((Object)this, mailServer));
        switch (mailServer.getType()) {
            case "pop": 
            case "imap": {
                this.eventPublisher.publish((Object)new MailServerAnalytics.InboundServerDeleted(mailServer.getType()));
                break;
            }
            default: {
                this.eventPublisher.publish((Object)new MailServerAnalytics.OutboundServerDeleted(mailServer.getType()));
            }
        }
    }

    private void publishEditEvent(MailServer mailServer) {
        logger.info("Updated {}", (Object)this.getServerDescription(mailServer));
        this.eventPublisher.publish((Object)new MailServerEditEvent((Object)this, mailServer, mailServer.getName()));
    }

    private void publishCreateEvent(MailServer mailServer) {
        logger.info("Created {}", (Object)this.getServerDescription(mailServer));
        this.eventPublisher.publish((Object)new MailServerCreateEvent((Object)this, mailServer));
        switch (mailServer.getType()) {
            case "pop": 
            case "imap": {
                this.eventPublisher.publish((Object)new MailServerAnalytics.InboundServerCreated(mailServer.getType()));
                break;
            }
            default: {
                this.eventPublisher.publish((Object)new MailServerAnalytics.OutboundServerCreated(mailServer.getType()));
            }
        }
    }

    private String getServerDescription(MailServer server) {
        return String.format("'%s' mail server '%s' at %s:%s", server.getType(), server.getName(), server.getHostname(), server.getPort());
    }

    public Map<Long, MailServer> getMailServers() {
        LinkedHashMap<Long, MailServer> mailServers = (LinkedHashMap<Long, MailServer>)this.bandanaManager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "atlassian.confluence.smtp.mail.accounts");
        if (!((mailServers = (Map)Optional.ofNullable(mailServers).orElse(new LinkedHashMap())) instanceof LinkedHashMap)) {
            mailServers = new LinkedHashMap<Long, MailServer>(mailServers);
        }
        mailServers.values().forEach(this::configureMailServer);
        mailServers.values().forEach(this::getPassword);
        mailServers.values().forEach(this::setAuthContextIfNeeded);
        return mailServers;
    }

    private List<? extends MailServer> getMailServers(Class<? extends MailServer> clazz) {
        return this.getMailServers().values().stream().filter(clazz::isInstance).collect(Collectors.toList());
    }

    private void configureMailServer(MailServer mailServer) {
        if (this.isTLSHostNameVerificationEnabled) {
            this.enableTLSHostNameVerificationOnSMTPServers(mailServer);
        }
        this.configureLogging(mailServer);
        Optional.ofNullable(this.getMailServerConfigurationHandler()).ifPresent(configHandler -> configHandler.configureMailServer(mailServer));
    }

    public void saveServerMap(Map<Long, MailServer> serverMap) {
        Map<Long, MailServer> deepCopy = this.deepCopyUsingSerialisation(serverMap);
        if (deepCopy != null && SecretService.getState() == SecretServiceState.ENABLED) {
            deepCopy.values().forEach(this::securePassword);
        }
        this.bandanaManager.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "atlassian.confluence.smtp.mail.accounts", deepCopy);
    }

    private void getPassword(MailServer server) {
        if (SecretService.getState() != SecretServiceState.ENABLED) {
            return;
        }
        if ("{ATL_SECURED}".equals(server.getPassword())) {
            try {
                Optional password = this.secretService.get(ConfluenceMailServerManager.getMailServerSecretId(server));
                if (password.isEmpty()) {
                    throw new IllegalStateException(String.format("Failed to fetch password for mail server [%s]. Expected secret [%s] not found.", server.getName(), ConfluenceMailServerManager.getMailServerSecretId(server)));
                }
                server.setPassword((String)password.get());
            }
            catch (SecretServiceException sse) {
                logger.error("Failed to fetch password for mail server [{}] from secret service - {}", (Object)server.getName(), (Object)sse.getCause());
            }
        }
    }

    private void securePassword(MailServer server) {
        if (server.getPassword() == null) {
            return;
        }
        try {
            this.secretService.put(ConfluenceMailServerManager.getMailServerSecretId(server), server.getPassword());
            server.setPassword("{ATL_SECURED}");
        }
        catch (SecretServiceException sse) {
            logger.error("Failed to save password for mail server [{}] to secret service - {}", (Object)server.getName(), (Object)sse.getCause());
        }
    }

    private void setAuthContextIfNeeded(MailServer mailServer) {
        if (mailServer instanceof ConfluenceSmtpMailServer) {
            ConfluenceSmtpMailServer smtpMailServer = null;
            try {
                smtpMailServer = (ConfluenceSmtpMailServer)mailServer;
                if (smtpMailServer.isBasicAuth()) {
                    return;
                }
                String tokenId = smtpMailServer.getAuthorization().getTokenId();
                if (tokenId.equals(INVALID_TOKEN_NAME)) {
                    logger.debug("Skipping setting authentication context for mail server {} as token id is invalid", (Object)mailServer.getName());
                    return;
                }
                ClientTokenEntity authToken = this.oAuth2Service.getToken(tokenId);
                DefaultConfluenceMailOAuth2Credentials confOAuthCreds = DefaultConfluenceMailOAuth2Credentials.builder().withUserName(smtpMailServer.getUsername()).withAccessToken(authToken.getAccessToken()).withRefreshToken(authToken.getRefreshToken()).withTokenId(authToken.getId()).withStatus(authToken.getStatus()).build();
                AuthenticationContext context = this.authCtxFactory.createAuthenticationContext((Credentials)confOAuthCreds);
                smtpMailServer.setAuthenticationContext(context);
            }
            catch (OAuth2Exception e) {
                String providerId = smtpMailServer.getAuthorization().getProviderId();
                Authorization.OAuth2 oAuth = new Authorization.OAuth2(providerId, INVALID_TOKEN_NAME);
                smtpMailServer.setAuthorization(oAuth);
                logger.warn("Failed to get oAuth configuration for mail server {}. Enable debug logging for full trace. Cause: {}", (Object)mailServer.getName(), (Object)e.getCause().getMessage());
                logger.debug("Failed to get oAuth configuration for mail server {}", (Object)mailServer.getName(), (Object)e);
            }
            catch (RuntimeException rte) {
                logger.error("Failed to set authentication context for mail server {}", (Object)mailServer.getName(), (Object)rte);
            }
        }
    }

    public void setBandanaManager(BandanaManagerInternal bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setSecretService(SecretService secretService) {
        this.secretService = secretService;
    }

    public void setAuthCtxFactory(ConfluenceAuthenticationContextFactory authCtxFactory) {
        this.authCtxFactory = authCtxFactory;
    }

    public void setOAuth2Service(OAuth2Service oAuth2Service) {
        this.oAuth2Service = oAuth2Service;
    }

    private void enableTLSHostNameVerificationOnSMTPServers(MailServer mailServer) {
        if (mailServer instanceof SMTPMailServer) {
            mailServer.setTlsHostnameCheckRequired(true);
        }
    }

    private void configureLogging(MailServer mailServer) {
        mailServer.setDebugStream(new PrintStream((OutputStream)new PasswordFilteringLogPrintStream(loggerSession, Level.DEBUG, mailServer.getPassword()), true, StandardCharsets.UTF_8));
        mailServer.setDebug(Boolean.getBoolean("mail.debug"));
        mailServer.setLogger(logger);
    }

    @VisibleForTesting
    Map<Long, MailServer> deepCopyUsingSerialisation(Map<Long, MailServer> serverMap) {
        return this.mailServerSerializationService.deepCopy(serverMap);
    }

    static String getMailServerSecretId(MailServer mailServer) {
        return MAIL_SERVER_PASSWORD_SECRET_PREFIX + mailServer.getId();
    }
}

