/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail;

import com.atlassian.confluence.content.datasource.DataSource;
import com.atlassian.confluence.mail.MessagingException;
import com.atlassian.confluence.mail.MimeBodyPart;
import com.atlassian.confluence.mail.template.MultipartBuilder;
import com.atlassian.core.task.Task;
import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.AbstractMailQueueItem;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.atlassian.mail.server.SMTPMailServer;
import jakarta.mail.BodyPart;
import jakarta.mail.Multipart;
import jakarta.mail.internet.MimeMultipart;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;

public final class Email
implements Task {
    private final com.atlassian.mail.Email delegate;

    public Email(String to) {
        this.delegate = new com.atlassian.mail.Email(to);
    }

    public void execute() throws Exception {
        new CalendarMailQueueItem(this.delegate).execute();
    }

    public void setBody(String body) {
        this.delegate.setBody(body);
    }

    public void setMimeType(String mimeType) {
        this.delegate.setMimeType(mimeType);
    }

    public void setFrom(String from) {
        this.delegate.setFrom(from);
    }

    public void setFromName(String fromName) {
        this.delegate.setFromName(fromName);
    }

    public void setTo(String to) {
        this.delegate.setTo(to);
    }

    public void setSubject(String subject) {
        this.delegate.setSubject(subject);
    }

    public void addHeader(String name, String value) {
        this.delegate.addHeader(name, value);
    }

    public void setReplyTo(String replyTo) {
        this.delegate.setReplyTo(replyTo);
    }

    public void setInReplyTo(String inReplyTo) {
        this.delegate.setInReplyTo(inReplyTo);
    }

    public void setMessageId(String messageId) {
        this.delegate.setMessageId(messageId);
    }

    public String getBody() {
        return this.delegate.getBody();
    }

    public void setDataSources(Collection<DataSource> dataSources) {
        this.delegate.setMultipart(MultipartBuilder.INSTANCE.makeMultipart(dataSources));
    }

    public void send(SMTPMailServer mailServer) throws MailException {
        mailServer.send(this.delegate);
    }

    public void addBodyPart(MimeBodyPart bodyPart) throws MessagingException {
        Multipart multipart = this.delegate.getMultipart();
        if (multipart == null) {
            multipart = new MimeMultipart("related");
            this.delegate.setMultipart(multipart);
        }
        try {
            multipart.addBodyPart((BodyPart)bodyPart.delegate);
        }
        catch (jakarta.mail.MessagingException e) {
            throw new MessagingException(e);
        }
    }

    public static class CalendarMailQueueItem
    extends AbstractMailQueueItem
    implements Serializable,
    Task {
        private static final long serialVersionUID = 1L;
        private com.atlassian.mail.Email email;
        private SingleMailQueueItem delegateMailQueueItem;

        public CalendarMailQueueItem(com.atlassian.mail.Email email) {
            this.email = email;
            this.delegateMailQueueItem = new SingleMailQueueItem(email);
        }

        public void send() throws MailException {
            this.delegateMailQueueItem.send();
        }

        public void execute() throws Exception {
            this.delegateMailQueueItem.send();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            int numBodyParts;
            Multipart multipart = this.email.getMultipart();
            out.writeObject(this.email.getTo());
            out.writeObject(this.email.getSubject());
            out.writeObject(this.email.getFrom());
            out.writeObject(this.email.getFromName());
            out.writeObject(this.email.getMimeType());
            out.writeObject(this.email.getBody());
            try {
                numBodyParts = multipart.getCount();
            }
            catch (jakarta.mail.MessagingException e) {
                throw new IOException(e);
            }
            out.writeInt(numBodyParts);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            for (int i = 0; i < numBodyParts; ++i) {
                os.reset();
                try {
                    multipart.getBodyPart(i).writeTo((OutputStream)os);
                }
                catch (jakarta.mail.MessagingException e) {
                    throw new IOException(e);
                }
                out.writeObject(os.toByteArray());
            }
        }

        public String getSubject() {
            return this.email.getSubject();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.email = new com.atlassian.mail.Email((String)in.readObject());
            this.email.setSubject((String)in.readObject());
            this.email.setFrom((String)in.readObject());
            this.email.setFromName((String)in.readObject());
            this.email.setMimeType((String)in.readObject());
            this.email.setBody((String)in.readObject());
            int numBodyParts = in.readInt();
            if (numBodyParts > 0) {
                MimeMultipart multipart = new MimeMultipart("related");
                for (int i = 0; i < numBodyParts; ++i) {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream((byte[])in.readObject());
                    try {
                        jakarta.mail.internet.MimeBodyPart mimeBodyPart = new jakarta.mail.internet.MimeBodyPart((InputStream)inputStream);
                        multipart.addBodyPart((BodyPart)mimeBodyPart);
                        continue;
                    }
                    catch (jakarta.mail.MessagingException e) {
                        throw new IOException(e);
                    }
                }
                this.email.setMultipart((Multipart)multipart);
            }
            this.delegateMailQueueItem = new SingleMailQueueItem(this.email);
        }

        public com.atlassian.mail.Email getEmail() {
            return this.email;
        }
    }
}

