/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail;

import com.atlassian.confluence.impl.util.serialize.AllowListLoader;
import com.atlassian.confluence.impl.util.serialize.SecureObjectSerializer;
import com.atlassian.mail.server.MailServer;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailServerSerializationService {
    private static final Logger log = LoggerFactory.getLogger(MailServerSerializationService.class);
    private static final String MAIL_ALLOWLIST_RESOURCE = "com/atlassian/confluence/impl/mail-config/mail-configuration-classes.allowlist";
    private static final String DEEP_COPY_FAILURE_MESSAGE = "Deep copy failed for mail server config.";
    private final AllowListLoader allowListLoader;

    public MailServerSerializationService(AllowListLoader allowListLoader) {
        this.allowListLoader = allowListLoader;
    }

    public Map<Long, MailServer> deepCopy(Map<Long, MailServer> serverMap) {
        if (serverMap == null) {
            return null;
        }
        if (serverMap.isEmpty()) {
            return Map.of();
        }
        try {
            Set<String> allowList = this.allowListLoader.loadAllowList(MAIL_ALLOWLIST_RESOURCE);
            SecureObjectSerializer serializer = new SecureObjectSerializer(allowList, MailServerSerializationService.class.getClassLoader());
            byte[] bytes = serializer.serialize((Serializable)((Object)serverMap));
            return serializer.deserialize(bytes, Map.class);
        }
        catch (Exception e) {
            log.error(DEEP_COPY_FAILURE_MESSAGE, (Throwable)e);
            throw new RuntimeException(DEEP_COPY_FAILURE_MESSAGE, e);
        }
    }
}

