/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail;

import com.atlassian.confluence.logging.LoggingOutputStream;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

class PasswordFilteringLogPrintStream
extends LoggingOutputStream {
    private final String password;
    private Pattern replacePattern = null;

    public PasswordFilteringLogPrintStream(@NonNull Logger log, @NonNull Level level, String password) {
        super(log, level);
        this.password = password;
        if (password != null) {
            this.replacePattern = Pattern.compile("(.*PASS.*?[ \"]|.*LOGIN.*?[ \"])" + Pattern.quote(password));
        }
    }

    @Override
    public String processLine(String s) {
        if ((s = super.processLine(s)) != null && this.password != null && this.password.length() > 2) {
            s = this.replacePattern.matcher(s).replaceAll("$1<hidden password>");
        }
        return s;
    }
}

