/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.auth;

import com.atlassian.confluence.mail.auth.ConfluenceMailOAuth2Credentials;
import com.atlassian.confluence.oauth2.OAuth2Exception;
import com.atlassian.confluence.oauth2.OAuth2Service;
import com.atlassian.mail.server.auth.AuthenticationContext;
import com.atlassian.mail.server.auth.Credentials;
import com.atlassian.oauth2.client.api.ClientToken;
import com.atlassian.oauth2.client.api.ClientTokenMetadata;
import jakarta.mail.AuthenticationFailedException;
import jakarta.mail.MessagingException;
import jakarta.mail.Service;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceOAuth2AuthenticationContext
implements AuthenticationContext {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceOAuth2AuthenticationContext.class);
    private static final Map<String, String> XOAUTH2_CONFIG = Map.of("mail.smtp.auth.mechanisms", "XOAUTH2", "mail.smtps.auth.mechanisms", "XOAUTH2");
    private final ConfluenceMailOAuth2Credentials credentials;
    private final OAuth2Service oAuth2Service;

    ConfluenceOAuth2AuthenticationContext(ConfluenceMailOAuth2Credentials credentials, OAuth2Service oAuth2Service) {
        this.credentials = Objects.requireNonNull(credentials);
        this.oAuth2Service = Objects.requireNonNull(oAuth2Service);
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public boolean isAuthenticating() {
        return this.credentials.getUserName() != null;
    }

    public Properties preparePropertiesForSession(Properties properties) {
        Properties sessionProperties = new Properties();
        sessionProperties.putAll((Map<?, ?>)properties);
        sessionProperties.putAll((Map<?, ?>)this.credentials.getProperties().orElseGet(Properties::new));
        sessionProperties.putAll(XOAUTH2_CONFIG);
        return sessionProperties;
    }

    public void connectService(Service service) throws MessagingException {
        log.debug("Connecting to service {} using XOAUTH2.", (Object)service.getURLName());
        try {
            this.connectUsingToken(service, this.credentials.getUserName(), this.credentials.getAccessToken());
        }
        catch (AuthenticationFailedException ex) {
            log.debug("XOAUTH2 authentication to service {} failed. Trying to recover.", (Object)service.getURLName());
            this.recoverOrRethrow(service, ex);
        }
    }

    private void recoverOrRethrow(Service service, AuthenticationFailedException cause) throws MessagingException {
        String tokenId = this.credentials.getTokenId();
        if (this.isTokenRecoverable()) {
            Optional<String> accessTokenOpt = this.refreshAccessToken(tokenId);
            if (accessTokenOpt.isPresent()) {
                this.connectUsingToken(service, this.credentials.getUserName(), accessTokenOpt.get());
                return;
            }
            log.debug("Won't connect to service {}. Token recovery failed.", (Object)service.getURLName());
        } else {
            log.debug("Won't connect to service {}. Invalid XOAUTH2 token.", (Object)service.getURLName());
        }
        throw cause;
    }

    private void connectUsingToken(Service service, String userName, String accessToken) throws MessagingException {
        service.connect(userName, accessToken);
        log.debug("Successful XOAUTH2 authentication to service {}.", (Object)service.getURLName());
    }

    private Optional<String> refreshAccessToken(String tokenId) {
        try {
            if (tokenId == null) {
                return Optional.empty();
            }
            ClientToken clientToken = this.oAuth2Service.getRefreshedToken(tokenId);
            return Optional.ofNullable(clientToken).map(ClientToken::getAccessToken);
        }
        catch (OAuth2Exception e) {
            log.debug("Access token can not be refreshed.", (Throwable)e);
            return Optional.empty();
        }
    }

    private boolean isTokenRecoverable() {
        return this.credentials.getTokenStatus() != null && !ClientTokenMetadata.ClientTokenStatus.UNRECOVERABLE.equals((Object)this.credentials.getTokenStatus());
    }
}

