/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.auth;

import com.atlassian.confluence.mail.auth.ConfluenceMailOAuth2Credentials;
import com.atlassian.oauth2.client.api.ClientTokenMetadata;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;

public class DefaultConfluenceMailOAuth2Credentials
implements ConfluenceMailOAuth2Credentials {
    private final String userName;
    private final String accessToken;
    private final String refreshToken;
    private final String tokenId;
    private final Properties properties;
    private final ClientTokenMetadata.ClientTokenStatus status;

    DefaultConfluenceMailOAuth2Credentials(Builder builder) {
        this.userName = builder.userName;
        this.accessToken = builder.accessToken;
        this.refreshToken = builder.refreshToken;
        this.tokenId = builder.tokenId;
        this.properties = builder.properties;
        this.status = builder.status;
    }

    @Override
    public String getTokenId() {
        return this.tokenId;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public Optional<Properties> getProperties() {
        return Optional.ofNullable(this.properties);
    }

    @Override
    public ClientTokenMetadata.ClientTokenStatus getTokenStatus() {
        return this.status;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultConfluenceMailOAuth2Credentials)) {
            return false;
        }
        DefaultConfluenceMailOAuth2Credentials that = (DefaultConfluenceMailOAuth2Credentials)o;
        return Objects.equals(this.userName, that.userName) && Objects.equals(this.accessToken, that.accessToken) && Objects.equals(this.refreshToken, that.refreshToken) && Objects.equals(this.tokenId, that.tokenId) && Objects.equals(this.properties, that.properties) && Objects.equals(this.status, that.status);
    }

    public final int hashCode() {
        return Objects.hash(this.userName, this.accessToken, this.refreshToken, this.tokenId, this.properties, this.status);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String userName;
        private String accessToken;
        private String refreshToken;
        private String tokenId;
        private Properties properties;
        private ClientTokenMetadata.ClientTokenStatus status = ClientTokenMetadata.ClientTokenStatus.UNKNOWN;

        Builder() {
        }

        public DefaultConfluenceMailOAuth2Credentials build() {
            return new DefaultConfluenceMailOAuth2Credentials(this);
        }

        public Builder withUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder withAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder withRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public Builder withTokenId(String tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder withProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public Builder withStatus(ClientTokenMetadata.ClientTokenStatus status) {
            this.status = status;
            return this;
        }
    }
}

