/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.HasLinkWikiMarkup;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.AddressablePage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.spaces.Space;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;

public abstract class AbstractPage
extends SpaceContentEntityObject
implements HasLinkWikiMarkup {
    private static final int MAX_PAGE_TITLE_LENGTH = 255;

    @EnsuresNonNullIf(expression={"title"}, result=true)
    public static boolean isValidPageTitle(String title) {
        return AbstractPage.isValidTitleLength(title);
    }

    public static boolean isValidTitleLength(String title) {
        return title != null && title.length() <= 255;
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(StringUtils.left((String)title, (int)255));
    }

    @Override
    public void convertToHistoricalVersion() {
        super.convertToHistoricalVersion();
        this.setAttachments(new ArrayList<Attachment>());
    }

    public AbstractPage getOriginalVersionPage() {
        return this.isLatestVersion() ? null : this.getLatestVersion();
    }

    public void setOriginalVersionPage(AbstractPage originalVersionPage) {
        this.setOriginalVersion(originalVersionPage);
    }

    public int getPreviousVersion() {
        return this.getVersion() - 1;
    }

    public Collection<Searchable> getSearchableDependants() {
        return List.copyOf(this.getComments());
    }

    @Override
    @Deprecated(forRemoval=true, since="9.3")
    public String getUrlPath() {
        return AddressablePage.of(this).getUrlPath();
    }

    public boolean isValidSpaceKey() {
        String spaceKey = this.getSpaceKey();
        return spaceKey.startsWith("~") && this.isValidUsername(spaceKey.substring(1)) || Space.isValidGlobalSpaceKey(spaceKey);
    }

    private boolean isValidUsername(String username) {
        return StringUtils.isNotEmpty((CharSequence)username) && !StringUtils.containsAny((CharSequence)username, (CharSequence)"\\,+<>'\"");
    }

    public List<Comment> getPageLevelComments() {
        ArrayList<Comment> pageLevelComments = new ArrayList<Comment>();
        for (Comment comment : this.getComments()) {
            if (comment.isInlineComment()) continue;
            pageLevelComments.add(comment);
        }
        return pageLevelComments;
    }

    public List<Comment> getTopLevelComments() {
        ArrayList<Comment> topLevelComments = new ArrayList<Comment>();
        for (Comment comment : this.getComments()) {
            if (comment.getParent() != null || comment.isInlineComment()) continue;
            topLevelComments.add(comment);
        }
        return topLevelComments;
    }

    @Override
    @Deprecated(forRemoval=true, since="9.3")
    public String getAttachmentsUrlPath() {
        return AddressablePage.of(this).getAttachmentsUrlPath();
    }

    @Override
    @Deprecated(forRemoval=true, since="9.3")
    public String getAttachmentUrlPath(Attachment attachment) {
        return AddressablePage.of(this).getAttachmentUrlPath(attachment);
    }

    @Override
    public AbstractPage getLatestVersion() {
        return (AbstractPage)super.getLatestVersion();
    }

    @Override
    public String getConfluenceRevision() {
        Object uuidPart = "";
        if (!StringUtils.isBlank((CharSequence)super.getCollaborativeEditingUuid())) {
            uuidPart = "$" + super.getCollaborativeEditingUuid();
        }
        return "confluence$content$" + this.getId() + (String)uuidPart + "." + super.getConfluenceRevision();
    }
}

