/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.confluence.core.Addressable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.util.ConfluenceRenderUtils;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.web.UrlBuilder;
import java.util.Objects;

public record AddressableAttachment(Attachment attachment) implements Addressable
{
    public static final String DOWNLOAD_PATH_BASE = "/download/attachments/";

    public static AddressableAttachment of(Attachment attachment) {
        return new AddressableAttachment(attachment);
    }

    @Override
    public long getId() {
        return this.attachment.getId();
    }

    @Override
    public String getDisplayTitle() {
        return this.attachment.getTitle();
    }

    @Override
    public String getUrlPath() {
        if (GeneralUtil.getParentPageOrBlog(this.attachment) == null) {
            return Objects.requireNonNull(this.attachment.getContainer()).getAttachmentUrlPath(this.attachment);
        }
        return GeneralUtil.getAttachmentUrl(this.attachment);
    }

    public String getDownloadPath() {
        return this.getDownloadPath(ConfluenceRenderUtils.getAttachmentsPathForContent(this.getContainer()), true);
    }

    public String getDownloadPathWithoutVersion() {
        return this.getDownloadPath(ConfluenceRenderUtils.getAttachmentsPathForContent(this.getContainer()), false);
    }

    public String getDownloadPathWithoutVersionOrApiRevision() {
        return this.getDownloadPath(ConfluenceRenderUtils.getAttachmentsPathForContent(this.getContainer()), false, false);
    }

    public String getDownloadPath(String attachmentPath, boolean addVersionInfo) {
        return this.getDownloadPath(attachmentPath, addVersionInfo, true);
    }

    private String getDownloadPath(String attachmentPath, boolean addVersionInfo, boolean addApiRevision) {
        String fileName = HtmlUtil.urlEncode(this.attachment.getFileName(), "UTF-8").replaceAll("\\+", "%20");
        Object path = attachmentPath == null ? "" : attachmentPath + "/";
        UrlBuilder builder = new UrlBuilder((String)path + fileName, "UTF-8");
        if (addVersionInfo) {
            builder.add("version", this.attachment.getVersion());
            if (this.attachment.getLastModificationDate() != null) {
                builder.add("modificationDate", this.attachment.getLastModificationDate().getTime());
            }
        }
        if (addApiRevision) {
            builder.add("api", "v2");
        }
        return builder.toString();
    }

    public String getDownloadPathWithoutEncoding() {
        return DOWNLOAD_PATH_BASE + this.getContainer().getId() + "/" + this.attachment.getFileName();
    }

    public String getExportPath() {
        Object fileExtension = this.attachment.getFileExtension();
        if (!((String)fileExtension).matches("[a-zA-Z0-9]+")) {
            fileExtension = "";
        }
        if (!((String)fileExtension).isEmpty()) {
            fileExtension = "." + (String)fileExtension;
        }
        return "attachments/" + this.getContainer().getId() + "/" + this.attachment.getId() + (String)fileExtension;
    }

    public String getExportPathForThumbnail() {
        return "attachments/thumbnails/" + this.getContainer().getId() + "/" + this.attachment.getId();
    }

    private ContentEntityObject getContainer() {
        return this.attachment.getContainer();
    }
}

