/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.confluence.core.Addressable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.UrlUtils;
import java.util.Objects;

public record AddressableComment(Comment comment) implements Addressable
{
    public static AddressableComment of(Comment comment) {
        return new AddressableComment(comment);
    }

    @Override
    public long getId() {
        return this.comment.getId();
    }

    @Override
    public String getDisplayTitle() {
        if (!this.comment.isLatestVersion()) {
            return ((ContentEntityObject)this.comment.getLatestVersion()).getDisplayTitle();
        }
        ContentEntityObject container = this.comment.getContainer();
        if (container == null) {
            return "Erroneous orphaned comment";
        }
        return "Re: " + container.getTitle();
    }

    @Override
    public String getUrlPath() {
        return this.getUrlPathForVersion((Comment)this.comment.getLatestVersion());
    }

    private String getUrlPathForVersion(Comment comment) {
        ContentEntityObject container = Objects.requireNonNull(comment.getContainer(), "Comment has no container, cannot generate URL path");
        if (container instanceof AbstractPage) {
            return UrlUtils.appendAmpersandOrQuestionMark(container.getUrlPath()) + "focusedCommentId=" + comment.getId() + "#comment-" + comment.getId();
        }
        if (container instanceof Attachment) {
            return GeneralUtil.getCommentUrl((Attachment)container, comment);
        }
        return container.getUrlPath() + "#comment-" + comment.getId();
    }
}

