/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.confluence.core.Addressable;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.UrlUtils;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.spring.container.ContainerManager;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Optional;

public record AddressablePage(AbstractPage page) implements Addressable
{
    public static AddressablePage of(AbstractPage page) {
        return new AddressablePage(page);
    }

    @Override
    public long getId() {
        return this.page.getId();
    }

    @Override
    public String getDisplayTitle() {
        return this.page.getTitle();
    }

    @Override
    public String getUrlPath() {
        return this.getUrlPath(true);
    }

    public String getUrlPath(boolean shouldDisplayTitle) {
        if (this.page.isLatestVersion() && this.page.getSpace() == null) {
            return "";
        }
        return AddressablePage.shouldUseReadableUrl() != false ? this.toUnicodePageUrl(shouldDisplayTitle) : this.toLegacyPageUrl(shouldDisplayTitle);
    }

    private static Boolean shouldUseReadableUrl() {
        return AddressablePage.getDarkFeatureManager().map(darkFeatureManager -> darkFeatureManager.isEnabledForAllUsers("confluence.readable.url").orElse(Boolean.FALSE)).orElse(false);
    }

    private static Optional<DarkFeatureManager> getDarkFeatureManager() {
        if (!ContainerManager.isContainerSetup()) {
            return Optional.empty();
        }
        return Optional.ofNullable((DarkFeatureManager)ContainerManager.getComponent((String)"salDarkFeatureManager", DarkFeatureManager.class));
    }

    private String toLegacyPageUrl(boolean shouldDisplayTitle) {
        boolean showDisplayUrl;
        boolean bl = showDisplayUrl = this.page.isLatestVersion() && !"blogpost".equalsIgnoreCase(this.page.getType()) && this.page.isValidSpaceKey() && UrlUtils.isSafeTitleForUrl(this.page.getTitle()) && shouldDisplayTitle;
        if (showDisplayUrl) {
            return "/display/" + HtmlUtil.urlEncode(this.page.getSpace().getKey(), StandardCharsets.UTF_8) + "/" + HtmlUtil.urlEncode(this.page.getTitle(), StandardCharsets.UTF_8);
        }
        return this.getIdBasedPageUrl();
    }

    private String toUnicodePageUrl(boolean shouldDisplayTitle) {
        String titleSlug;
        if (!this.page.isLatestVersion() || !this.page.isValidSpaceKey()) {
            return this.getIdBasedPageUrl();
        }
        String spaceKey = this.page.getSpaceKey();
        StringBuilder displayUrl = new StringBuilder("/spaces/");
        displayUrl.append(HtmlUtil.urlEncode(spaceKey, StandardCharsets.UTF_8));
        displayUrl.append("/");
        ContentTypeEnum contentType = ContentTypeEnum.forEntity(this.page);
        if (contentType == ContentTypeEnum.BLOG) {
            displayUrl.append("blog/");
            if (this.page.getCreationDate() != null) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd");
                displayUrl.append(df.format(this.page.getCreationDate()));
                displayUrl.append("/");
            }
        } else if (contentType == ContentTypeEnum.PAGE) {
            displayUrl.append("pages/");
        }
        displayUrl.append(this.page.getIdAsString());
        if (shouldDisplayTitle && !(titleSlug = this.generateTitleSlug()).isEmpty()) {
            displayUrl.append("/");
            displayUrl.append(titleSlug);
        }
        return displayUrl.toString();
    }

    public String getIdBasedPageUrl() {
        return "/pages/viewpage.action?pageId=" + this.getId();
    }

    public String generateTitleSlug() {
        return AddressablePage.generateTitleSlug(this.page.getTitle());
    }

    public static String generateTitleSlug(String title) {
        if (title == null) {
            return "";
        }
        String slug = title.replaceAll("[\\p{Punct}&&[^.~_-]]+", " ").replaceAll("\\p{Cntrl}", " ").replaceAll("\\s+", " ").trim();
        if (".".equals(slug) || "..".equals(slug)) {
            return "";
        }
        return HtmlUtil.urlEncode(slug, StandardCharsets.UTF_8).replaceAll("%3F", "");
    }

    public String getEditUrlPath() {
        return GeneralUtil.getEditPageUrl(this.page);
    }

    public String getAttachmentsUrlPath() {
        return "/pages/viewpageattachments.action?pageId=" + this.getId();
    }

    public String getAttachmentUrlPath(Attachment attachment) {
        return GeneralUtil.getAttachmentUrl(attachment);
    }
}

