/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.confluence.core.FileExportable;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.core.bean.EntityObject;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.io.InputStream;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ATTACHMENTDATA", indexes={@Index(name="attch_idver_idx", columnList="ATTVERSION, ATTACHMENTID")})
@NamedQueries(value={@NamedQuery(name="confluence.ad_findAttachmentDataByAttachment", query="from AttachmentData data where data.attachment = :attachment and data.version = :version"), @NamedQuery(name="confluence.ad_findAllHistoricalAttachmentDataByLatestAttachment", query="from AttachmentData data where data.attachment.originalVersion = :attachment")})
@Proxy(lazy=false)
public class AttachmentData
extends EntityObject
implements FileExportable {
    private int version;
    private Attachment attachment;
    private InputStream data;
    private int hibernateVersion;

    public AttachmentData() {
    }

    public AttachmentData(int version, Attachment attachment, InputStream data) {
        this.setVersion(version);
        this.setAttachment(attachment);
        this.setData(data);
    }

    @Id
    @GeneratedValue(generator="resettable-hilo-v5")
    @GenericGenerator(name="resettable-hilo-v5", strategy="com.atlassian.confluence.impl.hibernate.ResettableTableHiLoGeneratorV5")
    @Column(name="ATTACHMENTDATAID", updatable=false)
    public long getId() {
        return super.getId();
    }

    @Column(name="ATTVERSION", nullable=false)
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(name="ATTACHMENTID", nullable=false, unique=true)
    public Attachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    @Type(type="com.atlassian.confluence.impl.hibernate.SpoolingBlobInputStreamType")
    @Column(name="DATA", length=0x7FFFFFFF)
    public InputStream getData() {
        return this.data;
    }

    public void setData(InputStream data) {
        this.data = data;
    }

    @Version
    @ColumnDefault(value="0")
    @Column(name="HIBERNATEVERSION", nullable=false)
    int getHibernateVersion() {
        return this.hibernateVersion;
    }

    void setHibernateVersion(int hibernateVersion) {
        this.hibernateVersion = hibernateVersion;
    }
}

