/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.pages.AddressableAttachment;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.search.v2.SearchableAttachment;
import com.atlassian.core.util.FileSize;
import com.atlassian.spring.container.ContainerManager;
import java.io.InputStream;
import java.util.Collection;

public record IndexableAttachment(Attachment attachment) implements SearchableAttachment
{
    public static IndexableAttachment of(Attachment attachment) {
        return new IndexableAttachment(attachment);
    }

    public String getContentType() {
        return this.attachment.getMediaType();
    }

    public String getFileName() {
        return this.attachment.getTitle();
    }

    public InputStream getContentsAsStream() {
        return this.getContentsAsStream((AttachmentManager)ContainerManager.getComponent((String)"attachmentManager", AttachmentManager.class));
    }

    public InputStream getContentsAsStream(AttachmentManager attachmentManager) {
        return attachmentManager.getAttachmentData(this.attachment);
    }

    public String getComment() {
        return this.attachment.getVersionComment();
    }

    public String getNiceType() {
        return IndexableAttachment.getDescriptionForMimeType(this.attachment.getMediaType(), this.attachment.getFileExtension());
    }

    public static String getDescriptionForMimeType(String mimeType, String fileExtension) {
        Attachment.Type type = Attachment.Type.getForMimeType(mimeType, fileExtension);
        return type == null ? null : type.getDescription();
    }

    public String getNiceFileSize() {
        return FileSize.format((long)this.attachment.getFileSize());
    }

    public String getDownloadPath() {
        return AddressableAttachment.of(this.attachment).getDownloadPath();
    }

    public long getId() {
        return this.attachment.getId();
    }

    public Collection<Searchable> getSearchableDependants() {
        return this.attachment.getSearchableDependants();
    }

    public boolean isIndexable() {
        return this.attachment.isIndexable();
    }
}

