/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.impl.pages.actions.AttachmentUploadHelper;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.FileUploadManager;
import com.atlassian.confluence.util.AttachmentComparator;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.struts.multipart.AtlassianJakartaMultiPartRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public abstract class AbstractViewAttachmentsAction
extends ConfluenceActionSupport {
    protected AttachmentManager attachmentManager;
    private FileUploadManager fileUploadManager;
    protected List<String> highlight = new ArrayList<String>();
    private String sortBy = "date";
    private AttachmentUploadHelper attachmentUploadHelper;
    private String labels = "";

    private AtlassianJakartaMultiPartRequest getMultiPartRequest() {
        return this.strutsHelper.unwrapMultiPartRequest(this.getActiveRequest());
    }

    protected void validateUpload() {
        this.attachmentUploadHelper = new AttachmentUploadHelper(this.getMultiPartRequest(), this.getMaxAttachments(), this, this.fileUploadManager, this.attachmentManager, this.strutsHelper);
        if (this.attachmentUploadHelper.getUploadedFilesList().size() > this.getMaxAttachments()) {
            this.addActionError("error.max.attachments.upload", this.getMaxAttachments());
        }
        this.attachmentUploadHelper.validateAttachments();
        if (!this.attachmentUploadHelper.getErrors().isEmpty()) {
            this.setActionErrors(this.attachmentUploadHelper.getErrors());
            return;
        }
        this.attachmentUploadHelper.processMultipartRequest();
    }

    public String execute() throws Exception {
        if (!this.hasAttachFilePermissions()) {
            if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
                this.addActionError(this.getText("read.only.mode.default.error.short.message"));
            }
            return "error";
        }
        if (this.getMultiPartRequest() == null) {
            return "input";
        }
        this.validateUpload();
        if (!this.getActionErrors().isEmpty()) {
            return "input";
        }
        List<Attachment> attachments = this.attachmentUploadHelper.attachFiles(this.getContentEntityObject());
        this.addLabelsToAttachments(attachments);
        this.highlight = this.attachmentUploadHelper.getFilenamesSuccessfullyAttached();
        if (!this.getActionErrors().isEmpty()) {
            return "input";
        }
        return "success";
    }

    private void addLabelsToAttachments(List<Attachment> attachments) {
        if (!StringUtils.isBlank((CharSequence)this.labels)) {
            List<String> labelStringList = Arrays.asList(this.labels.split(","));
            for (Attachment att : attachments) {
                for (Label label : this.labelManager.getLabels(labelStringList)) {
                    this.labelManager.addLabel(att, label);
                }
            }
        }
    }

    public boolean hasAttachFilePermissions() {
        return this.permissionManager.hasCreatePermission(this.getAuthenticatedUser(), (Object)this.getContentEntityObject(), Attachment.class);
    }

    public abstract ContentEntityObject getContentEntityObject();

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public List<Attachment> getLatestVersionsOfAttachments() {
        List<Attachment> latestVersionsOfAttachments = this.attachmentManager.getLatestVersionsOfAttachments(this.getContentEntityObject());
        if (StringUtils.isNotEmpty((CharSequence)this.sortBy)) {
            boolean reverseMode = !"name".equals(this.sortBy);
            latestVersionsOfAttachments.sort(new AttachmentComparator(this.sortBy, reverseMode));
        }
        return latestVersionsOfAttachments;
    }

    public String[] getAttachmentDetails(Attachment attachment) {
        return new String[]{GeneralUtil.escapeXml(attachment.getFileName()), String.valueOf(attachment.getVersion())};
    }

    public long getUploadLimit() {
        return this.getGlobalSettings().getAttachmentMaxSize() / 1000000L;
    }

    public String getHighlightParameter() {
        StringBuilder highlightParameter = new StringBuilder();
        for (String highlightName : this.highlight) {
            highlightParameter.append("highlight=");
            highlightParameter.append(HtmlUtil.urlEncode(highlightName));
            highlightParameter.append("&");
        }
        return highlightParameter.toString();
    }

    public List<Attachment> getAllVersions(Attachment attachment) {
        return this.attachmentManager.getAllVersions(attachment);
    }

    public int getMaxAttachments() {
        return this.getGlobalSettings().getMaxAttachmentsInUI();
    }

    public void setFileUploadManager(FileUploadManager fileUploadManager) {
        this.fileUploadManager = fileUploadManager;
    }

    public List<String> getHighlight() {
        return this.highlight;
    }

    @StrutsParameter
    public void setHighlight(List<String> names) {
        this.highlight = names;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    @StrutsParameter
    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    @StrutsParameter
    public void setLabels(String labels) {
        this.labels = labels;
    }

    public String getLabels() {
        return this.labels;
    }
}

