/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.core.AttachmentResource;
import com.atlassian.confluence.core.Beanable;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.json.jsonator.Jsonator;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.FileUploadManager;
import com.atlassian.confluence.pages.actions.AttachmentUploadRequest;
import com.atlassian.struts.multipart.AtlassianJakartaMultiPartRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachFileAction
extends ConfluenceActionSupport
implements Beanable {
    private static final Logger log = LoggerFactory.getLogger(AttachFileAction.class);
    private AttachmentManager attachmentManager;
    private FileUploadManager fileUploadManager;
    private ContentEntityManager contentEntityManager;
    private long contentId;
    private final List<Attachment> attachmentsAdded = new ArrayList<Attachment>();
    private String responseFormat = "json";
    private Jsonator<?> jsonator;

    @Override
    public void validate() {
        AtlassianJakartaMultiPartRequest multiPartRequest = this.strutsHelper.unwrapMultiPartRequest(this.getActiveRequest());
        if (multiPartRequest == null) {
            this.addActionError(this.getText("attachment.upload.error.invalid.request"));
            return;
        }
        if (multiPartRequest.hasErrors()) {
            this.setActionErrors(this.strutsHelper.localizeStrutsMessages(multiPartRequest.getErrors()));
            return;
        }
        if (!this.permissionManager.hasCreatePermission(this.getAuthenticatedUser(), (Object)this.getContentEntityObject(), Attachment.class)) {
            this.addActionError(this.getText("attachment.upload.not.permitted"));
            return;
        }
        AttachmentUploadRequest uploadRequest = new AttachmentUploadRequest(multiPartRequest);
        if (uploadRequest.getResourceCount() > this.getMaxAttachments()) {
            this.addActionError("error.max.attachments.upload", this.getMaxAttachments());
        }
        for (AttachmentResource file : uploadRequest.getResources()) {
            if (StringUtils.isBlank((CharSequence)file.getFilename())) {
                this.addActionError("fileName.required");
            }
            if (StringUtils.length((CharSequence)file.getComment()) <= 255) continue;
            this.addActionError("attachment.comment.too.long", file.getFilename());
        }
    }

    public String execute() {
        AttachmentUploadRequest uploadRequest = new AttachmentUploadRequest(Objects.requireNonNull(this.strutsHelper.unwrapMultiPartRequest(this.getActiveRequest())));
        ContentEntityObject content = this.getContentEntityObject();
        List<AttachmentResource> resources = uploadRequest.getResources();
        for (AttachmentResource resource : resources) {
            log.debug("Uploaded file '{}' will be attached to '{}'", (Object)resource, (Object)content);
            this.fileUploadManager.storeResource(resource, content);
            this.attachmentsAdded.add(this.attachmentManager.getAttachment(content, resource.getFilename()));
        }
        return this.responseFormat;
    }

    @Override
    public Object getBean() {
        return Map.of("attachmentsAdded", this.attachmentsAdded);
    }

    private int getMaxAttachments() {
        return this.getGlobalSettings().getMaxAttachmentsInUI();
    }

    @Override
    public boolean isPermitted() {
        return super.isPermitted();
    }

    private ContentEntityObject getContentEntityObject() {
        return this.contentEntityManager.getById(this.contentId);
    }

    @StrutsParameter
    public void setContentId(long contentId) {
        this.contentId = contentId;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setFileUploadManager(FileUploadManager fileUploadManager) {
        this.fileUploadManager = fileUploadManager;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    @StrutsParameter
    public void setResponseFormat(String responseFormat) {
        this.responseFormat = responseFormat;
    }

    public void setJsonator(Jsonator<?> jsonator) {
        this.jsonator = jsonator;
    }

    public Jsonator<?> getJsonator() {
        return this.jsonator;
    }
}

