/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.core.Beanable;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.themes.GlobalHelper;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.breadcrumbs.AttachmentBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.Breadcrumb;
import com.atlassian.confluence.util.breadcrumbs.BreadcrumbGenerator;
import com.atlassian.confluence.util.breadcrumbs.UserBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.spaceia.SpaceBreadcrumb;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@AnonymousSiteAccess
public class BreadcrumbAction
extends ConfluenceActionSupport
implements PageAware,
Beanable {
    private static final String NOT_FOUND = "pagenotfound";
    private SpaceManager spaceManager;
    private List<Breadcrumb> breadcrumbs;
    private String spaceKey;
    private long pageId;
    private String title;
    private AbstractPage page;
    private String fileName;
    private String userName;
    private String breadcrumbType;
    private BreadcrumbGenerator breadcrumbGenerator;
    private int ellipsisIndex = -1;
    private int ellipsisLength = 0;

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)this.userName)) {
            return this.handleUserBreadcrumb();
        }
        if (this.fileName != null) {
            return this.handleAttachmentBreadcrumb();
        }
        if (this.page != null || StringUtils.isNotEmpty((CharSequence)this.title) || this.pageId != 0L) {
            return this.page != null ? this.handlePageBreadcrumb() : NOT_FOUND;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.spaceKey) && StringUtils.isEmpty((CharSequence)this.title)) {
            return this.handleSpaceBreadcrumb();
        }
        return NOT_FOUND;
    }

    private String handleUserBreadcrumb() {
        ConfluenceUser targetUser = this.userAccessor.getUserByName(this.userName);
        if (targetUser == null) {
            return NOT_FOUND;
        }
        ConfluenceUser currentUser = this.getAuthenticatedUser();
        if (!this.permissionManager.hasPermission(currentUser, Permission.VIEW, targetUser)) {
            return NOT_FOUND;
        }
        this.breadcrumbs = this.getBreadcrumbs(null, new UserBreadcrumb(targetUser));
        this.breadcrumbType = "userinfo";
        return this.breadcrumbs != null ? "success" : NOT_FOUND;
    }

    private String handlePageBreadcrumb() {
        Space space = this.page.getLatestVersion().getSpace();
        Breadcrumb breadcrumb = this.breadcrumbGenerator.getContentBreadcrumb(space, this.page);
        if (breadcrumb == null) {
            return NOT_FOUND;
        }
        this.breadcrumbs = this.getBreadcrumbs(space, breadcrumb);
        List<Breadcrumb> ellipsisCrumbs = new GlobalHelper(this).getEllipsisCrumbs(this.breadcrumbs);
        this.ellipsisIndex = ellipsisCrumbs.isEmpty() ? -1 : this.breadcrumbs.indexOf(ellipsisCrumbs.get(0));
        this.ellipsisLength = ellipsisCrumbs.size();
        this.breadcrumbType = this.page instanceof Page ? "page" : "blogpost";
        return "success";
    }

    private String handleSpaceBreadcrumb() {
        Space space = this.spaceManager.getSpace(this.spaceKey);
        if (space == null) {
            return NOT_FOUND;
        }
        this.breadcrumbs = this.getBreadcrumbs(space, new SpaceBreadcrumb(space));
        this.breadcrumbType = "space";
        return "success";
    }

    private String handleAttachmentBreadcrumb() {
        if (this.page == null) {
            return NOT_FOUND;
        }
        Attachment attachment = this.page.getAttachmentNamed(this.fileName);
        if (attachment == null) {
            return NOT_FOUND;
        }
        this.breadcrumbs = this.getBreadcrumbs(this.page.getLatestVersion().getSpace(), new AttachmentBreadcrumb(attachment));
        this.breadcrumbType = "attachment";
        return "success";
    }

    private List<Breadcrumb> getBreadcrumbs(Space space, Breadcrumb breadcrumb) {
        if (space != null) {
            breadcrumb = new com.atlassian.confluence.util.breadcrumbs.SpaceBreadcrumb(space).concatWith(breadcrumb);
        }
        breadcrumb.setFilterTrailingBreadcrumb(false);
        return this.breadcrumbGenerator.getFilteredBreadcrumbTrail(space, breadcrumb);
    }

    @Override
    public Object getBean() {
        return Map.of("breadcrumbs", this.breadcrumbs, "type", this.breadcrumbType, "ellipsisIndex", this.ellipsisIndex, "ellipsisLength", this.ellipsisLength);
    }

    @StrutsParameter
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @StrutsParameter
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @StrutsParameter
    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    @StrutsParameter
    public void setTitle(String title) {
        this.title = title;
    }

    @StrutsParameter
    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    @Override
    public void setPage(AbstractPage page) {
        this.page = page;
    }

    @Override
    public AbstractPage getPage() {
        return this.page;
    }

    @Override
    public boolean isPageRequired() {
        return false;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    @Override
    public boolean isLatestVersionRequired() {
        return true;
    }

    @Override
    public boolean isViewPermissionRequired() {
        return true;
    }

    public Space getSpace() {
        return this.getPage() == null ? null : this.getPage().getSpace();
    }

    public void setBreadcrumbGenerator(BreadcrumbGenerator breadcrumbGenerator) {
        this.breadcrumbGenerator = breadcrumbGenerator;
    }
}

