/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.content.service.BlogPostService;
import com.atlassian.confluence.content.service.blogpost.BlogPostProvider;
import com.atlassian.confluence.content.service.blogpost.CreateBlogPostCommand;
import com.atlassian.confluence.content.service.page.CreateContextProvider;
import com.atlassian.confluence.core.service.CommandActionHelper;
import com.atlassian.confluence.core.service.ServiceCommand;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.actions.AbstractCreatePageAction;
import com.atlassian.confluence.pages.actions.CalendarLanguageUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.UrlUtils;
import com.atlassian.confluence.util.breadcrumbs.Breadcrumb;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
public class CreateBlogPostAction
extends AbstractCreatePageAction {
    private BlogPostService blogPostService;
    private CommandActionHelper helper;
    private SimpleBlogPostProvider blogPostProvider;
    private static final long ONE_DAY = TimeUnit.DAYS.toMillis(1L);

    @Override
    protected CommandActionHelper getCommandActionHelper() {
        if (this.helper == null) {
            this.helper = new CommandActionHelper(this.createCommand());
        }
        return this.helper;
    }

    @Override
    protected void initialiseProvider(AbstractPage abstractPage) {
        this.blogPostProvider.setBlogPost((BlogPost)abstractPage);
    }

    protected ServiceCommand createCommand() {
        this.blogPostProvider = new SimpleBlogPostProvider();
        return this.blogPostService.newCreateBlogPostCommand((BlogPostProvider)this.blogPostProvider, (CreateContextProvider)this.contextProvider, this.getDraftAsCEO(), this.getAuthenticatedUser());
    }

    @Override
    public void validate() {
        super.validate();
        this.getCommandActionHelper();
        BlogPost blog = new BlogPost();
        if (this.getPostingDateAsDate() != null) {
            blog.setCreationDate(this.getPostingDateAsDate());
        } else {
            blog.setCreationDate(new Date());
        }
        this.checkCreationDate();
        blog.setSpace(this.getSpace());
        try {
            blog.setTitle(this.getTitle());
            this.getCommandActionHelper().validate(this);
        }
        catch (InfrastructureException infrastructureException) {
            // empty catch block
        }
    }

    @Override
    public boolean isPermitted() {
        this.getCommandActionHelper();
        BlogPost blog = new BlogPost();
        blog.setSpace(this.getSpace());
        blog.setTitle(this.getTitle());
        blog.setCreationDate(this.getPostingDateAsDate());
        this.blogPostProvider.setBlogPost(blog);
        return this.getCommandActionHelper().isAuthorized() && this.hasDraftPermission();
    }

    @Override
    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @Override
    protected void populateContextProvider() {
        this.contextProvider.getContext().put("PostingDate", this.getPostingDateAsDate());
    }

    private void checkCreationDate() {
        if (this.getPostingDateAsDate().after(new Date(System.currentTimeMillis() + ONE_DAY))) {
            this.addActionError(this.getText("news.date.in.future"));
        }
    }

    @Override
    protected AbstractPage getCreatedAbstractPage() {
        return ((CreateBlogPostCommand)this.getCommandActionHelper().getCommand()).getCreatedBlogPost();
    }

    @Override
    protected AbstractPage getPageToCreate() {
        BlogPost blogPost = new BlogPost();
        blogPost.setCreationDate(this.getPostingDateAsDate());
        return blogPost;
    }

    @Override
    public String getCancelRedirectUrl() {
        if (this.collaborativeEditingHelper.isSharedDraftsFeatureEnabled(this.getSpace().getKey())) {
            return super.getCancelRedirectUrl();
        }
        if (this.getPage() == null) {
            return "/dashboard.action#recently-worked";
        }
        if (StringUtils.isNotBlank((CharSequence)this.originalReferrer) && !UrlUtils.isEditingUrl(this.originalReferrer)) {
            return this.originalReferrer;
        }
        return "viewrecentblogposts.action?key=" + HtmlUtil.urlEncode(this.space.getKey());
    }

    @Override
    public Date getPostingDateAsDate() {
        Date postingDate = super.getPostingDateAsDate();
        return postingDate != null ? postingDate : new Date();
    }

    public String getCalendarI18nFile() {
        return CalendarLanguageUtil.getInstance().getCalendarFilenameForLanguage(this.getLocale().getLanguage());
    }

    public void setBlogPostService(BlogPostService blogPostService) {
        this.blogPostService = blogPostService;
    }

    @Override
    protected Breadcrumb getContentBreadcrumb() {
        return this.breadcrumbGenerator.getContentCollectorBreadcrumb(this.getSpace(), BlogPost.class);
    }

    private static class SimpleBlogPostProvider
    implements BlogPostProvider {
        private BlogPost blog;

        private SimpleBlogPostProvider() {
        }

        void setBlogPost(BlogPost blog) {
            this.blog = blog;
        }

        @Override
        public BlogPost getBlogPost() {
            return this.blog;
        }
    }
}

