/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.confluence.web.Cookies;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@AnonymousSiteAccess
public class DirectoryViewListPagesAction
extends AbstractSpaceAction
implements SpaceAware {
    private static final String PLUGIN_KEY = "list-content-tree";
    private long openPageId = -1L;
    private List<Long> openedNodes = Collections.emptyList();
    private PageManager pageManager;

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        Cookies.setResponseCookie("confluence.list.pages.cookie", PLUGIN_KEY);
        Page openPage = this.pageManager.getPage(this.openPageId);
        if (this.isOpenNode() && openPage != null) {
            List<Page> ancestors = openPage.getAncestors();
            ArrayList<Long> newOpenedNodes = new ArrayList<Long>();
            for (int i = ancestors.size() - 1; i >= 0; --i) {
                Page page = ancestors.get(i);
                if (page == null) continue;
                newOpenedNodes.add(page.getId());
            }
            this.openedNodes = List.copyOf(newOpenedNodes);
        }
        return "success";
    }

    @StrutsParameter
    public void setOpenId(long openPageId) {
        this.openPageId = openPageId;
    }

    public boolean isOpenNode() {
        return this.openPageId != -1L;
    }

    public List getOpenedNodes() {
        return this.openedNodes;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public long getOpenId() {
        return this.openPageId;
    }

    @Override
    public boolean isSpaceRequired() {
        return true;
    }

    @Override
    public boolean isViewPermissionRequired() {
        return true;
    }
}

